import * as categoryService from "../service/fianceAccountCategory.service";
import { FinanceAccountCategoryVO, FinanceAccountCategoryPageVO } from "../service/fianceAccountCategory.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { coinType, contractPairs, spotPairs } from "@madex/ex-ts-dao";

let isIp = require('is-ip');
/**
 * 分类列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: FinanceAccountCategoryPageVO) => {
    let func_name = "financeAccountCategory.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await categoryService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加新的分类
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, financeAccountCategoryVO: FinanceAccountCategoryVO) => {
    let func_name = "financeAccountCategory.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(financeAccountCategoryVO);

        let res = await categoryService.add(financeAccountCategoryVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改分类
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, financeAccountCategoryVO: FinanceAccountCategoryVO) => {
    let func_name = "financeAccountCategory.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!financeAccountCategoryVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(financeAccountCategoryVO);

        let res = await categoryService.update(financeAccountCategoryVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除分类
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, financeAccountCategoryVO: FinanceAccountCategoryVO) => {
    let func_name = "financeAccountCategory.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!financeAccountCategoryVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await categoryService.del(financeAccountCategoryVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

async function paramValid(financeAccountCategoryVO: FinanceAccountCategoryVO) {
    if (!financeAccountCategoryVO.name) {
        throw ErrorCode.PARAM_MISS;
    }
}

