import * as appFeatureService from "../service/appFeature.service";
import { AppFeatureVO, AppFeaturePageVO } from "../service/appFeature.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { DEVICE_ARR, PLATFORM_ARR, STATUS_ARR } from "../../../constant/appVersionConstant";
import { appFeatureManage, arbitrageOrmDB } from "@madex/ex-ts-dao";

let isIp = require('is-ip');
let _ = require('lodash');
/**
 * app首页入口列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: AppFeaturePageVO) => {
    let func_name = "appFeature.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await appFeatureService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加新的App首页入口
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, appFeatureVO: AppFeatureVO) => {
    let func_name = "appFeature.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (appFeatureVO.is_fixed == 1 && appFeatureVO.is_default == 1) {
            throw ErrorCode.FIXED_AND_DEFAULT
        }

        let res = await appFeatureService.add(appFeatureVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改app入口信息
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, appFeatureVO: AppFeatureVO) => {
    let func_name = "appFeature.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!appFeatureVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        if (appFeatureVO.is_fixed == 1 && appFeatureVO.is_default == 1) {
            throw ErrorCode.FIXED_AND_DEFAULT
        }

        if (appFeatureVO.is_fixed == 0) {
            await checkIsFixedCount(appFeatureVO.id);
        }

        let res = await appFeatureService.update(appFeatureVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除app入口信息
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, appFeatureVO: AppFeatureVO) => {
    let func_name = "appFeature.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!appFeatureVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await appFeatureService.del(appFeatureVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 校验固定数量
 * @param id
 */
async function checkIsFixedCount(id: number) {
    let dbInfoList = await appFeatureManage.prototype.findAll({
        where: {
            is_fixed: 1,
            is_hidden: 0,
            id: { [arbitrageOrmDB.Op.ne]: id }
        },
        raw: true
    });

    let map: any = {};
    for (let item of dbInfoList) {
        let featureArrStr = item.feature;
        let featureArr = JSON.parse(featureArrStr);
        for (let one of featureArr) {
            let lang = one.lang;
            if (!map[lang]) {
                map[lang] = 1;
            }
            else {
                let count = map[lang];
                map[lang] = count + 1;
            }
        }
    }

    let keys = _.keys(map);
    for (let key of keys) {
        if (map[key] < 2) {
            throw ErrorCode.NOT_HIDDEN_TWO
        }
    }
}

