import * as aclPositionService from "../service/aclPosition.service";
import { AclAuthVO, AclAuthPageVO, AclRolePageVO, AclRoleVO } from "../service/aclRoleAuth.service";
import { getCurrentUserId, } from "../../../utils/aclUserUtils";
import { ErrorCode } from "../../../constant/errorCode";
import { getUserFillsFromCore, getUserOrdersFromCore } from "../../../utils/coreSystemUtils";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

export interface QueryVo {
    market?: string// spot 现货  lpc 合约

    user_id?: number

    before?: string//上一页传 这个

    after?: string//下一页传 这个

    limit?: number//条数

    symbol?: string//交易对

    start_time?: any//时间

    end_time?: any//时间

    order_id?: string//订单ID
}

export const pendingList = async (queryVo: QueryVo) => {
    let param = {
        market: queryVo.market ? queryVo.market : "spot",
        user_id: queryVo.user_id,
        status: "unsettled",//当前委托
    }
    if (queryVo.symbol) {
        param['symbol'] = queryVo.symbol
    }
    if (queryVo.start_time) {
        param['start_time'] = new Date(queryVo.start_time).getTime();
    }
    if (queryVo.end_time) {
        param['end_time'] = new Date(queryVo.end_time).getTime();
    }
    if (queryVo.before) {
        param['before'] = queryVo.before
    }
    if (queryVo.after) {
        param['after'] = queryVo.after
    }
    if (queryVo.limit) {
        param['limit'] = queryVo.limit
    }

    let res = await getUserOrdersFromCore(param);
    return res;
};

export const historyList = async (queryVo: QueryVo) => {
    let param = {
        market: queryVo.market ? queryVo.market : "spot",
        user_id: queryVo.user_id,
        status: "settled",//历史委托
    };
    if (queryVo.symbol) {
        param['symbol'] = queryVo.symbol
    }
    if (queryVo.start_time) {
        param['start_time'] = new Date(queryVo.start_time).getTime();
    }
    if (queryVo.end_time) {
        param['end_time'] = new Date(queryVo.end_time).getTime();
    }
    if (queryVo.before) {
        param['before'] = queryVo.before
    }
    if (queryVo.after) {
        param['after'] = queryVo.after
    }
    if (queryVo.limit) {
        param['limit'] = queryVo.limit
    }
    let res = await getUserOrdersFromCore(param);
    return res;
};

export const detailList = async (queryVo: QueryVo) => {
    let param = {
        user_id: queryVo.user_id,
        market: queryVo.market ? queryVo.market : "spot",
    };
    if (queryVo.symbol) {
        param['symbol'] = queryVo.symbol
    }
    if (queryVo.start_time) {
        param['start_time'] = new Date(queryVo.start_time).getTime();
    }
    if (queryVo.end_time) {
        param['end_time'] = new Date(queryVo.end_time).getTime();
    }
    if (queryVo.before) {
        param['before'] = queryVo.before
    }
    if (queryVo.after) {
        param['after'] = queryVo.after
    }
    if (queryVo.limit) {
        param['limit'] = queryVo.limit
    }
    if (queryVo.order_id) {
        param['order_id'] = queryVo.order_id
    }
    let res = await getUserFillsFromCore(param);
    return res;
};



