import { madAdminOrmDB, coinAddress, coinType, mainUserAsset, dwdSpotAssetsApi, ormDB } from "@madex/ex-ts-dao";
import { getOneAbkUserByAccount, getOneAbkUserByUid, checkAbkTotp } from "../../../../utils/abkUserUtils";
import { ErrorCode } from "../../../../constant/errorCode";
import { AbkUserInfoConst } from "../../../../constant/abkUserConstant";
import { CryptUtils } from "../../../../utils/crypt-utils";
import { RedisVal } from "../../../../constant/redis-val";
import Config from "../../../../../config";
import BigNumber from "bignumber.js";
import { it } from "node:test";

const Otplib = require('otplib');

let { logger, apiAssertUtils: ApiAssert, BigNumberUtils } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');

let _ = require('lodash');


export async function userAddrList(page: any, size: any, user_id: any) {
    let where: any = {};
    if (user_id) {
        where["user_id"] = Number(user_id);
    }
    let res = await coinAddress.prototype.findAndCount({
        attributes: ['user_id', 'coin_id', 'coin_symbol', 'address', 'createdAt'],
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["createdAt", "desc"]],
        raw: true
    });
    if (res.rows.length) {
        let coinIds = res.rows.map(item => item.coin_id);
        let coinMap = await getCoinTypeMapByCoinOrAssetIds(coinIds);
        for (let item of res.rows) {
            item.chain_type = coinMap[item.coin_id].chain_type;
            item.coin_symbol = coinMap[item.coin_id].symbol;
        }
    }
    return res;
}

export async function assetDetails(user_id: any) {
    let where: any = {};
    where["user_id"] = Number(user_id);

    let assets_map: any = {};

    let asset_id_list: any = [];

    let task1 = mainUserAsset.prototype.findAll({
        attributes: ['asset_id', 'symbol', 'balance', 'holds'],
        where: where,
        raw: true
    });

    let task2 = dwdSpotAssetsApi.prototype.findAll({
        attributes: ['asset_id', 'asset_symbol', 'balance', 'unreal_profit'],
        where: where,
        raw: true
    });

    let [dbMainAssets, dbTradeAssets] = await Promise.all([task1, task2]);

    for (let item of dbMainAssets) {
        let total = new BigNumber(item.balance).add(new BigNumber(item.holds));
        assets_map[item.asset_id] = assets_map[item.asset_id] ? assets_map[item.asset_id].add(total) : total;
        if (!asset_id_list.includes(item.asset_id)) {
            asset_id_list.push(item.asset_id);
        }
    }

    for (let item of dbTradeAssets) {
        let total = new BigNumber(item.balance).add(new BigNumber(item.unreal_profit));
        assets_map[item.asset_id] = assets_map[item.asset_id] ? assets_map[item.asset_id].add(total) : total;
        if (!asset_id_list.includes(item.asset_id)) {
            asset_id_list.push(item.asset_id);
        }
    }

    let coinMap = await getCoinTypeMapByCoinOrAssetIds([], asset_id_list);

    let asset_keys = _.keys(assets_map);
    let res: any = [];
    for (let assetKey of asset_keys) {
        let balance = assets_map[Number(assetKey)];
        let symbol = coinMap[Number(assetKey)] ? coinMap[Number(assetKey)].symbol : "";
        let chain_type = coinMap[Number(assetKey)] ? coinMap[Number(assetKey)].chain_type : "";
        res.push({
            chain_type,
            symbol,
            balance
        });
    }
    return res;

}


export async function siteAssets(page: any, size: any) {

    let pageData = await coinType.prototype.findAndCount({
        attributes: ['symbol', 'chain_type'],
        where: {
            main_status: 2//已经提交到撮合
        },
        limit: size,
        offset: (page - 1) * size,
        order: [['id', 'asc']],
        raw: true
    });
    if (!pageData.rows.length) {
        return pageData;
    }
    let symbols = pageData.rows.map(item => item.symbol);

    let [mainAssetsMap, tradeAssetsMap] = await Promise.all([getSiteMainAssetsBySymbols(symbols), getSiteTradeAssetsBySymbols(symbols)]);

    for (let item of pageData.rows) {
        let balance = new BigNumber(mainAssetsMap[item.symbol] || 0).add(new BigNumber(tradeAssetsMap[item.symbol] || 0));
        item.balance = balance;
    }
    return pageData;
}


async function getCoinTypeMapByCoinOrAssetIds(coin_ids: any[], asset_ids?: any[]) {
    let map: any = {};
    let where: any = {};
    let coin_id_flag = false;
    if (coin_ids.length) {
        where["id"] = coin_ids;
        coin_id_flag = true;
    }
    else {
        where["asset_id"] = asset_ids;
    }

    let dbList = await coinType.prototype.findAll({
        where: where,
        raw: true
    });

    for (let item of dbList) {
        if (coin_id_flag) {
            map[item.id] = item;
        }
        else {
            map[item.asset_id] = item;
        }
    }
    return map;
}

async function getSiteMainAssetsBySymbols(symbols: any[]) {
    let map: any = {};
    let mainAssetsList = await mainUserAsset.prototype.findAll({
        attributes: ['symbol', ormDB.literal('sum(balance) as balance'),
            ormDB.literal('sum(holds) as holds'),],
        where: {
            symbol: symbols
        },
        group: ['symbol'],
        raw: true
    });
    for (let item of mainAssetsList) {
        map[item.symbol] = new BigNumber(item.balance).add(new BigNumber(item.holds));
    }
    return map;
}

async function getSiteTradeAssetsBySymbols(symbols: any[]) {
    let map: any = {};
    let tradeAssetsList = await dwdSpotAssetsApi.prototype.findAll({
        attributes: ['asset_symbol', ormDB.literal('sum(balance) as balance'),
            ormDB.literal('sum(unreal_profit) as unreal_profit'),],
        where: {
            asset_symbol: symbols
        },
        group: ['asset_symbol'],
        raw: true
    });
    for (let item of tradeAssetsList) {
        map[item.asset_symbol] = new BigNumber(item.balance).add(new BigNumber(item.unreal_profit));
    }
    return map;
}



