import { coinTx, coinWithdraw, ormDB } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface QueryVO {
    page?: number,

    size?: number,

    status?: number;

    condition?: string;

    from_time?: Date | any,

    to_time?: Date | any,

}


export async function depositList(pageVO: QueryVO) {

    let where = {};
    if (pageVO.condition) {
        let or = {
            to: pageVO.condition,
            tx_id: pageVO.condition,
            coin_symbol: pageVO.condition,
        }
        if (!isNaN(Number(pageVO.condition))) {
            or['user_id'] = Number(pageVO.condition)
        }
        where[ormDB.Op.or] = or;
    }
    if (pageVO.status || pageVO.status === 0) {
        if (pageVO.status === 1) {
            where['status'] = { [ormDB.Op.gt]: 0 }
        }
        else {
            where['status'] = pageVO.status
        }
    }
    if (pageVO.from_time && pageVO.to_time) {
        where['createdAt'] = { [ormDB.Op.between]: [pageVO.from_time, pageVO.to_time] }
    }

    let resList = await coinTx.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["createdAt", "desc"]],
        raw: true
    });
    return resList;
}


export async function withdrawList(pageVO: QueryVO) {


    let where = {};
    if (pageVO.condition) {
        let or = {
            to_address: pageVO.condition,
            tx_id: pageVO.condition,
            coin_symbol: pageVO.condition,
        }
        if (!isNaN(Number(pageVO.condition))) {
            or['user_id'] = Number(pageVO.condition)
        }
        where[ormDB.Op.or] = or
    }
    if (pageVO.status || pageVO.status === 0) {
        if (pageVO.status === -1) {
            where['status'] = { [ormDB.Op.lt]: 0 }
        }
        else {
            where['status'] = pageVO.status
        }
    }
    if (pageVO.from_time && pageVO.to_time) {
        where['createdAt'] = { [ormDB.Op.between]: [pageVO.from_time, pageVO.to_time] }
    }

    let resList = await coinWithdraw.prototype.findAndCount({
        where: where,
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["createdAt", "desc"]],
        raw: true
    });
    return resList;
}


