import { AppVersionPageVO } from "../service/appVersion.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { APP_VERSION_KEY } from "../../../constant/redis-val";
import { addOptLog } from "../service/userOptLog.service";

let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');

let isIp = require('is-ip');
/**
 * app审核管理列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: AppVersionPageVO) => {
    let func_name = "appApplyVersion.control.list";
    try {
        let key = APP_VERSION_KEY + 'ios';
        let data = await RedisClient.getSync(key);
        let res = {
            ios: data ? data :""
        }
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改
 * @param req
 * @param authConfigVO
 */
export const modify = async (req: any, pageVO: AppVersionPageVO) => {
    let func_name = "appApplyVersion.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!pageVO.type || !pageVO.version) {
            throw ErrorCode.PARAM_MISS
        }
        if (!['ios', 'android'].includes(String(pageVO.type))) {
            throw ErrorCode.PARAM_MISS;
        }
        let key = APP_VERSION_KEY + pageVO.type;
        await RedisClient.writeSync(key, pageVO.version);
        //管理后台操作日志
        addOptLog(currentUserId, 0, 'App审核管理修改', ip, `key:${key},value:${pageVO.version}`, 'App审核管理');
        return Res3Utils.result('ok');
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

