import { exPairApply, coinType, ormDB, systemTrigger, spotPairs, exTradeArea, exBusinessAreaRouter } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";
import { addCoin2Core, addPairToCore } from "../../../utils/coreSystemUtils";
import { PAIR_APPLY_STATUS } from "../../../constant/pairApplyConst";


let _ = require('lodash');
let { logger, datetimeUtils } = require('@madex/ex-js-public');


export interface CronApplyVO {
    id?: number;

    trigger_symbol?: string;

    trigger_type?: number;

    trigger_action?: number;

    trigger_time?: Date | any;

    status?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface CronApplyPageVO extends CronApplyVO {

    page?: number,

    size?: number,

}


export async function list(pageVO: CronApplyPageVO) {

    let resList = await systemTrigger.prototype.findAndCount({
        limit: pageVO.size,
        offset: (Number(pageVO.page) - 1) * Number(pageVO.size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}


export async function del(id: number, currentUser: any, ip: string | undefined) {


    let dbInfo = await systemTrigger.prototype.findOne({
        where: { id: id },
        raw: true
    });
    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST
    }
    if (dbInfo && dbInfo.status != 0) {
        throw ErrorCode.NO_TRIGGER_DEL
    }
    await systemTrigger.prototype.destroy({
        where: {
            id: id
        }
    });
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '删除审核上币定时器', ip, JSON.stringify(dbInfo), '交易上下线管理');
    return 'success';
}


export async function addDeposit(cronApplyVO: CronApplyVO, currentUser: any, ip: any) {

    let dbCoin = await coinType.prototype.findOne({
        where:{
            symbol:cronApplyVO.trigger_symbol
        },
        raw:true
    });
    if (!dbCoin){
        throw ErrorCode.COIN_DATA_NOT_EXIST
    }
    cronApplyVO.trigger_type = 1;
    cronApplyVO.trigger_action = 1021;
    cronApplyVO.status = 0;
    cronApplyVO.createdAt = new Date();
    cronApplyVO.updatedAt = new Date();
    await systemTrigger.prototype.create(cronApplyVO);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '增加新币充值定时器', ip, JSON.stringify(cronApplyVO), '交易上下线管理');
    return 'success';
}



export async function addWithdraw(cronApplyVO: CronApplyVO, currentUser: any, ip: any) {

    let dbCoin = await coinType.prototype.findOne({
        where:{
            symbol:cronApplyVO.trigger_symbol
        },
        raw:true
    });
    if (!dbCoin){
        throw ErrorCode.COIN_DATA_NOT_EXIST
    }
    cronApplyVO.trigger_type = 1;
    cronApplyVO.trigger_action = 1031;
    cronApplyVO.status = 0;
    cronApplyVO.createdAt = new Date();
    cronApplyVO.updatedAt = new Date();
    await systemTrigger.prototype.create(cronApplyVO);
    //管理后台操作日志
    addOptLog(currentUser.userId, 0, '增加新币提现定时器', ip, JSON.stringify(cronApplyVO), '交易上下线管理');
    return 'success';
}




