import * as mUserAssetsService from "../service/mUserAssets.service";
import { QueryVO} from "../service/mUserAssets.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";

/**
 * 钱包账户资产详情
 * @param req
 * @param infoVO
 */
export const walletAssetDetail = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserAssetsCtrl.walletAssetDetail";
    try {
        queryVO.page = Optional.opt(queryVO, 'page', 1);
        queryVO.size = Optional.opt(queryVO, 'size', 20);
        if (!queryVO.user_id){
            throw ErrorCode.PARAM_MISS
        }
        let res = await mUserAssetsService.walletAssetDetail(queryVO.user_id, Number(queryVO.page), Number(queryVO.size));
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 资产分布
 * @param req
 * @param infoVO
 */
export const assetDistribution = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserAssetsCtrl.assetDistribution";
    try {
        if (!queryVO.user_id){
            throw ErrorCode.PARAM_MISS
        }
        let res = await mUserAssetsService.assetDistribution(queryVO.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 交易账户资产详情
 * @param req
 * @param infoVO
 */
export const tradeAssetsDetail = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserAssetsCtrl.tradeAssetsDetail";
    try {
        queryVO.page = Optional.opt(queryVO, 'page', 1);
        queryVO.size = Optional.opt(queryVO, 'size', 20);
        if (!queryVO.user_id){
            throw ErrorCode.PARAM_MISS
        }
        let res = await mUserAssetsService.tradeAssetsDetail(queryVO.user_id, Number(queryVO.page), Number(queryVO.size));
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

