import * as service from "../service/spotPair.service";
import { AddParam, ListParam } from "../service/spotPair.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');


export const list = async (req: any, param: ListParam) => {
    let func_name = "spotPairCtl.list";
    let cmd = req.path;
    try {
        param.page = Optional.opt(param, 'page', 1);
        param.size = Optional.opt(param, 'size', 50);
        let res = await service.list(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
//新增
export const save = async (req: any, param: AddParam) => {
    let func_name = "spotPairCtl.save";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.base);
        ApiAssert.notNull('3000', param.quote);
        ApiAssert.notNull('3000', param.symbol);
        ApiAssert.notNull('3000', param.name);
        ApiAssert.notNull('3000', param.price_scale);
        ApiAssert.notNull('3000', param.quantity_scale);
        ApiAssert.notNull('3000', param.maker_fee);
        ApiAssert.notNull('3000', param.taker_fee);
        let res = await service.save(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
//修改
export const update = async (req: any, param: AddParam) => {
    let func_name = "spotPairCtl.save";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.id);
        let res = await service.update(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


export const pushToCoreSystem = async (req: any, id: any) => {
    let func_name = "spotPairCtl.pushToCoreSystem";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', id);
        let res = await service.pushToCoreSystem(id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const getAllSubmitSuccess = async (req: any, param: ListParam) => {
    let func_name = "spotPairCtl.getAllSubmitSuccess";
    let cmd = req.path;
    try {
        let res = await service.getAllSubmitSuccess();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
