import { userApikeyStrict, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');


export interface ContractPairVO {
    id?: number,

    symbol?: string;

    base?: string;

    quote?: string;

    leverage_init?: number;

    leverage_min?: number;

    leverage_max?: number;

    margin_rate_maintain?: string,

    margin_rate_init?: string,

    risk_level_base?: number,

    maker_fee?: string,

    taker_fee?: string,

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface ContractPairPageVO extends ContractPairVO {

    page?: number,

    size?: number,

}


export async function query(pageVO: ContractPairPageVO) {
    let key = 'contract.pair.query';
    //TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let list = await RedisClient.getSync(key);
    let res = {
        count: list ? list.length : 0,
        rows: list ? list : []
    }
    return res;
}


export async function set(contractPairVO: ContractPairVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    contractPairVO.createdAt = new Date();
    contractPairVO.updatedAt = new Date();
    let key = 'contract.pair.query';
    let list = await RedisClient.getSync(key);
    if (list) {
        contractPairVO.id = list.length + 1;
        list.push(contractPairVO);
    }
    else {
        contractPairVO.id = 1;
        list = [];
        list.push(contractPairVO);
    }
    await RedisClient.writeSync(key,list);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增合约交易对', ip, JSON.stringify(contractPairVO), '交易管理');
    return 'success';
}


export async function update(contractPairVO: ContractPairVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let key = 'contract.pair.query';
    let list = await RedisClient.getSync(key);
    let nList:any[] = [];
    for (let item of list) {
        let one = item;
        if (item.id == contractPairVO.id){
            one = contractPairVO;
        }
        nList.push(one);
    }
    await RedisClient.writeSync(key,nList);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改合约交易对', ip, JSON.stringify(contractPairVO), '交易管理');

    return 'success';
}



