/**
 * 原文件:b024-spot.rpc.utils.js
 */
import {
    ormDB,
    userInfo,
    coinType,
    mainUserAsset,
    userInfoSon,
    feeRateSpotLog,
    feeRateContractLog,
    commonUserFeeSetting,
    feeRateBaseCoinContractLog, spotPairs, contractPairs
} from "@madex/ex-ts-dao";
import { FEE_RATE_LOG_STATUS } from "../../src/constant/feeRateLogConst";
import { changeTradingFee, getPairFromCore } from "../../src/utils/coreSystemUtils";

let BigNumber = require('bignumber.js');

const logger = require('@madex/ex-js-public').logger;


let user_info = userInfo.prototype;
let coin_type = coinType.prototype;
let fee_rate_spot_log = feeRateSpotLog.prototype;
let feeRateCheckStatus = FEE_RATE_LOG_STATUS;


let WHITE_LIST: any = [];


const sleep = ms => new Promise((res) => setTimeout(res, ms));

/**
 * 检查交易对是否存在
 * @param pair
 * @param type 1 现货 2 U本位合约 3 币本位合约
 */
let checkPair = async function (pair: string, type: number) {
    let _func_name_ = 'task.fee.rate.log.model.checkPair';
    if (!pair || !type) {
        throw '3000';
    }
    let dbPair: any;
    if (type == 1) {//现货
        dbPair = await spotPairs.prototype.findOne({
            attributes: ['id'],
            where: {
                symbol: String(pair),
                status: 2,//提交成功
            },
            raw: true,
        });
    }
    else {//U、币本位合约
        dbPair = await contractPairs.prototype.findOne({
            attributes: ['id'],
            where: {
                symbol: String(pair),
                status: 2,//提交成功
            },
            raw: true,
        })
    }
    if (!dbPair) {
        logger.warn(_func_name_, `spot_pairs or contract_pairs  no found ${pair} or no push core`);
        throw '3000';
    }
    return dbPair;
};

let checkUser = async function (user_id) {
    let _func_name_ = 'task.fee.rate.log.model.checkUser';
    if (!user_id || isNaN(user_id)) {
        throw '3000';
    }
    let dbinfo = await user_info.findOne({
        attributes: ['user_id'],
        where: {
            user_id: Number(user_id),
        },
        raw: true,
    });
    if (!dbinfo) {
        logger.warn(_func_name_, `user_info no found ${user_id}`);
        throw '3000';
    }
    return dbinfo;
};

let checkFeeModel = async function (fee_model) {
    let _func_name_ = 'task.fee.rate.log.model.checkFeeModel';
    let validFeeModel = {
        fixed: 1,
        fixedingain: 1,
        tered: 1,
        tieredingain: 1,
        fixedingainuser: 1,
    };
    if (!validFeeModel[fee_model]) {
        logger.warn(_func_name_, `fee_model error ${fee_model}`);
        throw '3000';
    }
};

let cancelIfSpotFeeExist = async function (user_id, pair, maker_fee, taker_fee, logId) {
    //TODO:原来获取正在生效的用户费率查此表 现在 ？？？
    /* let dbFee = await DAO.spotUserFee.prototype.findOne({
         where: {
             user_id,
             pair,
         },
         raw: true,
     });*/

    let feeExist = false;
    /*if (dbFee) {
        if (dbFee.maker_fee == maker_fee && dbFee.taker_fee == taker_fee) {
            feeExist = true;
        }
    }
    else if (maker_fee == 0.001 && taker_fee == 0.002) {
        feeExist = true;
    }*/

    if (feeExist) {
        throw 'fee exist';
    }
}

let checkFeeRate = async function (fee_rate) {
    let _func_name_ = 'spotRpcUtils.checkFeeRate';
    if (isNaN(fee_rate) || Math.abs(Number(fee_rate)) > 0.005 || fee_rate < 0) {
        logger.warn(_func_name_, `fee_rate error ${fee_rate}`);
        throw '3000';
    }
};


let cancelIfContractFeeExist = async function (user_id, pair, maker_fee, taker_fee,logId) {

    //TODO:原来获取正在生效的用户费率查此表 现在 ？？？
    /*let dbFee = await baseUUser.prototype.findOne({
        where : {
            user_id,
            pair,
        },
        raw : true,
    });*/

    let feeExist = false;
    /*if (dbFee) {
        if (dbFee.maker_fee == maker_fee && dbFee.taker_fee == taker_fee) {
            feeExist = true;
        }
    } else if (maker_fee == 0.0004 && taker_fee == 0.00060){
        feeExist = true;
    }*/


    if (feeExist) {
        throw 'fee exist';
    }
}

export const changeUserSpotFee = async function (user_id, symbol, fee_model, maker_fee, taker_fee, logId) {
    let is_success = true;
    await checkFeeModel(fee_model);
    try {
        await cancelIfSpotFeeExist(user_id, symbol, maker_fee, taker_fee, logId);
    }
    catch (error) {
        if (error == 'fee exist') {
            return is_success;
        }
    }
    let asset = await mainUserAsset.prototype.findOne({
        where: {
            user_id
        },
        raw: true
    })
    if (!asset) {
        return is_success;
    }
    if (isNaN(maker_fee) || Math.abs(Number(maker_fee)) > 0.005) { // maker (-0.005, 0.005); // 正负千五
        logger.warn(' task.fee.rate.log.model.changeUserSpotFee ', ` maker_fee fee_rate error ${maker_fee}`);
        throw '3000';
    }
    if (isNaN(taker_fee) || taker_fee < 0 || taker_fee > 0.005) { // taker 最小为0
        logger.warn(' task.fee.rate.log.model.changeUserSpotFee ', ` taker_fee fee_rate error ${taker_fee}`);
        throw '3000';
    }
    await checkPair(symbol, 1);
    await checkUser(user_id);

    await sleep(1000);
    //请求撮合 修改费率
    let res = await changeTradingFee(symbol, user_id, maker_fee, taker_fee);
    return res.is_success;
};


export const changeUserContractFee = async function (user_id, symbol, fee_model, maker_fee, taker_fee, logId) {
    let _func_name_ = 'task.fee.rate.log.model.changeUserContractFee';

    let is_success = true;
    await checkPair(symbol, 2);
    try {
        await cancelIfContractFeeExist(user_id, symbol, maker_fee, taker_fee, logId);
    }
    catch (error) {
        if (error == 'fee exist') {
            return is_success;
        }
    }
    let asset = await mainUserAsset.prototype.findOne({
        where: {
            user_id
        },
        raw: true
    })
    if (!asset) {
        return is_success;
    }
    if (maker_fee < -0.0003) { // 最大返0.0003
        logger.warn(_func_name_, `fee_rate error ${maker_fee}`);
        throw '3000';
    }
    if (taker_fee < 0 || taker_fee > 0.005) {
        logger.warn(_func_name_, `fee_rate error ${taker_fee}`);
        throw '3000';
    }
    maker_fee = new BigNumber(String(maker_fee)).toFixed(7);
    taker_fee = new BigNumber(String(taker_fee)).toFixed(7);
    await checkUser(user_id);

    await sleep(1000);
    //请求撮合 修改费率
    let res = await changeTradingFee(symbol, user_id, maker_fee, taker_fee);
    return res.is_success;
};


export const isWhiteListUser = async function (user_id: number) {
    let father_id = await getMainAccountUserId(user_id);
    if (WHITE_LIST.includes(father_id) || Number(father_id) < 100000) {
        return true;
    }
    return false;
}

async function getMainAccountUserId(user_id: number) {
    let dbSon = await userInfoSon.prototype.findOne({
        where: {
            user_id: Number(user_id)
        }
    });
    let father_id = dbSon ? dbSon.father_id : user_id;
    return father_id;
}
