import * as i18nService from "../service/i18n.service";
import { I18nInfoVO, I18nInfoPageVO } from "../service/i18n.service";
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
let isIp = require('is-ip');

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

/**
 * 分页查询当前版本国际化信息列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, infoPageVO: I18nInfoPageVO) => {
    let func_name = "i18nCtrl.list";
    let cmd = req.path;
    try {
        infoPageVO.page = Optional.opt(infoPageVO, 'page', 1);
        infoPageVO.size = Optional.opt(infoPageVO, 'size', 20);
        if (!infoPageVO.site){
            throw ErrorCode.PARAM_MISS;
        }

        let res = await i18nService.list(infoPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 添加国际化信息-发布版本
 * @param req
 * @param infoVO
 */
export const add = async (req: any, infoVO: I18nInfoVO) => {
    let func_name = "i18nCtrl.add";
    let cmd = req.path;
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!infoVO.site){
            throw ErrorCode.PARAM_MISS;
        }
        let res = await i18nService.add(infoVO,currentUserId,ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加国际化信息-发布版本-预览
 * @param req
 * @param infoVO
 */
export const preview = async (req: any, infoVO: I18nInfoVO) => {
    let func_name = "i18nCtrl.preview";
    let cmd = req.path;
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        if (!infoVO.site){
            throw ErrorCode.PARAM_MISS;
        }
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await i18nService.preview(infoVO,currentUserId,ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
/**
 * 国际化信息版本列表
 * @param req
 * @param infoVO
 */
export const versionList = async (req: any, infoVO: I18nInfoVO) => {
    let func_name = "i18nCtrl.versionList";
    let cmd = req.path;
    try {
        if (!infoVO.site){
            throw ErrorCode.PARAM_MISS;
        }
        let res = await i18nService.versionList(infoVO.site);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


