import * as apikeyStrictService from "../service/apikeyStrict.service";
import { ApikeyStrictVO, ApikeyStrictPageVO } from "../service/apikeyStrict.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * API限速列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: ApikeyStrictPageVO) => {
    let func_name = "apikeyStrict.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await apikeyStrictService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加新的API限速
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, apikeyStrictVO: ApikeyStrictVO) => {
    let func_name = "apikeyStrict.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(apikeyStrictVO);

        let res = await apikeyStrictService.add(apikeyStrictVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改API限速
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, apikeyStrictVO: ApikeyStrictVO) => {
    let func_name = "apikeyStrict.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!apikeyStrictVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(apikeyStrictVO);

        let res = await apikeyStrictService.update(apikeyStrictVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除Api限速
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, apikeyStrictVO: ApikeyStrictVO) => {
    let func_name = "apikeyStrict.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!apikeyStrictVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await apikeyStrictService.del(apikeyStrictVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


async function paramValid(apikeyStrictVO: ApikeyStrictVO) {
    let userId = apikeyStrictVO.user_id;
    let limit = apikeyStrictVO.limit;
    if (!userId || !limit) {
        throw ErrorCode.PARAM_MISS
    }
    if (limit < 10 || limit > 2000) {
        throw ErrorCode.LIMIT_ERROR;
    }
}

