import * as depositAndWithdrawService from "../service/depositAndWithdraw.service";
import { QueryVO } from "../service/depositAndWithdraw.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');

/**
 * 客服部-资金管理-充值列表
 * @param req
 * @param infoVO
 */
export const depositList = async (req: any, pageVO: QueryVO) => {
    let func_name = "depositAndWithdraw.control.depositList";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await depositAndWithdrawService.depositList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 客服部-资金管理-提现列表
 * @param req
 * @param infoVO
 */
export const withdrawList = async (req: any, pageVO: QueryVO) => {
    let func_name = "depositAndWithdraw.control.withdrawList";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await depositAndWithdrawService.withdrawList(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


