import { AppVersionPageVO } from "../service/appVersion.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { APP_VERSION_KEY, REWARD_TIME_PERIOD_REDIS_KEY } from "../../../constant/redis-val";
import { addOptLog } from "../service/userOptLog.service";

let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');

let isIp = require('is-ip');

export interface ParamVO {
    period_type?: number;// 1:半年；2:一年；3:2年；4:永久；
}


/**
 * 时间周期设置
 * @param req
 * @param authConfigVO
 */
export const set = async (req: any, paramVO: ParamVO) => {
    let func_name = "rewardTimePeriod.control.set";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!paramVO.period_type || ![1,2,3,4].includes(Number(paramVO.period_type))) {
            throw ErrorCode.PARAM_MISS
        }

        let key = REWARD_TIME_PERIOD_REDIS_KEY;
        await RedisClient.writeSync(key, paramVO.period_type);
        //管理后台操作日志
        addOptLog(currentUserId, 0, '返佣时间周期设置', ip, `key:${key},value:${paramVO.period_type}`, '返佣时间周期设置');
        return Res3Utils.result('ok');
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 时间周期配置查询
 * @param req
 * @param authConfigVO
 */
export const get = async (req: any, paramVO: ParamVO) => {
    let func_name = "rewardTimePeriod.control.get";
    try {
        let key = REWARD_TIME_PERIOD_REDIS_KEY;
        let period_type = await RedisClient.getSync(key);
        //管理后台操作日志
        return Res3Utils.result({
            period_type: period_type ? period_type : ""
        });
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

