import * as systemTriggerService from "../service/systemTrigger.service";
import { SystemTriggerVO, SystemTriggerPageVO } from "../service/systemTrigger.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { coinType, spotPairs } from "@madex/ex-ts-dao";

let isIp = require('is-ip');
/**
 * 触发配置列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: SystemTriggerPageVO) => {
    let func_name = "systemTrigger.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await systemTriggerService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加新的触发配置
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, systemTriggerVO: SystemTriggerVO) => {
    let func_name = "systemTrigger.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(systemTriggerVO);

        let res = await systemTriggerService.add(systemTriggerVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改触发配置
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, systemTriggerVO: SystemTriggerVO) => {
    let func_name = "systemTrigger.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!systemTriggerVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        await paramValid(systemTriggerVO);

        let res = await systemTriggerService.update(systemTriggerVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除触发配置
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, systemTriggerVO: SystemTriggerVO) => {
    let func_name = "systemTrigger.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!systemTriggerVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await systemTriggerService.del(systemTriggerVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

async function paramValid(systemTriggerVO: SystemTriggerVO) {

    let symbolOrPair = systemTriggerVO.trigger_symbol;
    let triggerType = systemTriggerVO.trigger_type;
    if (!symbolOrPair || !triggerType || !systemTriggerVO.trigger_time) {
        throw ErrorCode.PARAM_MISS
    }
    if (triggerType == 1) {
        let dbInfo = await coinType.prototype.findOne({
            where: {
                symbol: symbolOrPair
            },
            raw: true
        });
        if (!dbInfo) {
            throw ErrorCode.COIN_TYPE_NOT_EXIST
        }
    }
    else {
        //TODO:  这个需要确定下  之前的有 激活 隐藏 开启/关闭充值  开启/关闭提现  开启/关闭划转  现在没有对应的 激活 隐藏对应的字段了
        // 之前的 只有 ex_pair  现在现货和合约是分开的  查询的是  spot_pairs 是否需要补充别的查询合约交易对的逻辑？？？
        // 触发活动（coin_type:1xxx -- is_active=0 : 1010,is_active=1 :1011 ,enable_deposit=0:1020,enable_deposit=1:1021, enable_withdraw=0:1030,enable_withdraw=1:1031,enable_transfer=0:1040,enable_transfer=1:1041;
        // ex_pair:2xxx -- is_active=0:2010,is_active=1:2011, is_hide=0:2020,is_hide=1:2021)
        let dbInfo = await spotPairs.prototype.findOne({
            where: {
                symbol: symbolOrPair
            },
            raw: true
        });
        if (!dbInfo) {
            throw ErrorCode.PAIR_NOT_EXIST
        }
    }
}

