import { ormDB, feeRateContractLog } from "@madex/ex-ts-dao";
import { FEE_RATE_LOG_STATUS } from "../../../constant/feeRateLogConst";

export const getByIdList = async function (ids: any) {
    let list = await feeRateContractLog.prototype.findAll({
        where: {
            id: { [ormDB.Op.in]: ids }
        },
        raw: true
    });
    return list;
}

/**
 * 需要注意在上层处理事务
 * @param ids
 * @param tx
 */
export const uncheck2Deleted = async function (ids: any, tx: any) {
    await feeRateContractLog.prototype.update({
        is_check: FEE_RATE_LOG_STATUS.CHECK_STATUS_DELETED
    }, {
        where: {
            id: { [ormDB.Op.in]: ids },
            is_check: FEE_RATE_LOG_STATUS.CHECK_STATUS_UNCHECK
        },
        transaction: tx
    });
}