'use strict';
import * as ReqUtils from "../utils/req-utils";

const {
    Res3Utils,
    logger: Logger,
} = require("@madex/ex-js-public");


let cmdWhiteList = {
    //国际化
    'i18n/info/list': 1,
    'i18n/info/add': 1,
    'i18n/info/update': 1,
    'i18n/info/del': 1,
    'i18n/info/log/list': 1,
    'i18n/info/log/revert': 1,

    'spotPair/add': 1,
    'spotPair/list': 1,
    'spotPair/spotPairCtl': 1,

    'coinType/add': 1,
    'coinType/list': 1,
    'coinType/spotPairCtl': 1,

    //权限管理 - 我的权限
    'user/getInfo': 1,
    'user/getInfoByUserId': 1,
    'user/getInfoDetailByUserId': 1,
    //权限管理 - 组织结构
    'department/pageList': 1,
    'department/allList': 1,
    'department/getDepartmentTree': 1,
    'department/add': 1,
    'department/update': 1,
    'department/del': 1,
    'department/userList/dpIdsOrAccount': 1,
    'position/allList': 1,
    //权限管理 - 后台角色管理
    'acl/role/list': 1,
    'acl/role/getByUser': 1,
    'acl/role/getAll': 1,
    'acl/role/save': 1,
    'acl/role/del': 1,
    'acl/changeRoleAuth': 1,
    'acl/auth/list': 1,
    'acl/auth/tree': 1,
    'acl/auth/getByUser': 1,
    'acl/auth/getByRole': 1,
    'acl/auth/save': 1,
    'acl/auth/del': 1,
    //权限管理 - 后台用户管理
    'acl/user/add': 1,
    'acl/user/list': 1,
    'acl/user/update': 1,
    'acl/user/checkTotpCode': 1,
    'acl/changeUserRole': 1,
    'acl/user/opt/log/list': 1,

    'user/login': 1,
    'user/logout': 1,
    'user/login/confirm': 1,
    'user/bind/totp/ask': 1,
    'user/bind/totp/confirm': 1,
    'user/auth/reset/totp': 1,

    //热门交易对搜索
    'hot/pair/config/list': 1,
    'hot/pair/config/add': 1,
    'hot/pair/config/update': 1,
    'hot/pair/config/del': 1,
    //消息通知
    'notice/list': 1,
    'notice/add': 1,
    'notice/update': 1,
    //Madex 用户管理
    'mUser/manage/userList': 1,
    'mUser/manage/oneUserDetail': 1,
    'mUser/manage/updateUserEmail': 1,
    'mUser/manage/lockAccount': 1,
    'mUser/manage/unlockAccount': 1,
    'mUser/manage/clearLoginLimit': 1,
    'mUser/manage/clear24WithdrawLimit': 1,
    'mUser/manage/kyc/list': 1,
    'mUser/manage/kyc/oneDetail': 1,
    'mUser/manage/kyc/audit': 1,
    'mUser/manage/kyc/auditors': 1,
    'mUser/manage/walletAsset/detail': 1,
    'mUser/manage/asset/distribution': 1,
    'mUser/manage/tradeAsset/detail': 1,
    'mUser/manage/order/pending/list': 1,
    'mUser/manage/order/history/list': 1,
    'mUser/manage/order/detail/list': 1,
    //资源位管理
    'link/useful/list': 1,
    'link/useful/add': 1,
    'link/useful/delete': 1,
    'link/useful/update': 1,
    'link/useful/detail': 1,
    //邮件订阅
    'mUser/subscribe/list': 1,
    'mUser/subscribe/delete': 1,
    'mUser/subscribe/count': 1,
    'mUser/subscribe/mail/history': 1,
    'mUser/subscribe/mail/send': 1,
    'mUser/subscribe/mail/detail': 1,
    'mUser/subscribe/mail/send/group': 1,
    //普通用户手续费
    'mUser/fee/setting/list': 1,
    'mUser/fee/setting/add': 1,
    'mUser/fee/setting/update': 1,
    'mUser/fee/setting/delete': 1,
    'mUser/fee/setting/submit': 1,


};


let filter = function (app: any) {
    app.use(function (req, res, next) {
        let path = ReqUtils.parsePath(req.originalUrl);
        try {
            //如果是非登录接口，可以直接跳过
            if (!cmdWhiteList[path]) {
                throw '3000'
            }
            next();
        }
        catch (e) {
            Logger.error(`access-limit filter error!! - ${e}`);
            return res.json(Res3Utils.getErrorResult(e));
        }
    });
};
module.exports = {
    filter: filter,
};