import * as userOptService from "../service/userOpt.service";
import { AclUserInfoVO, AclUserInfoPageVO } from "../service/aclUser.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUser, getCurrentUserId, } from "../../../utils/aclUserUtils";
import * as service from "../service/collateral.service";
import { VO } from "../service/collateral.service";

let isIp = require('is-ip');


export const list = async (req: any) => {
    let func_name = "usefulLinkCtrl.list";
    try {
        let res = await service.list();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const save = async (req: any, vo: VO) => {
    let func_name = "usefulLinkCtrl.save";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await paramValid(vo);
        let res = await service.save(vo, currentUserId, ip);

        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


async function paramValid(vo: VO) {
    if (!vo.symbol || !vo.discount ) {
        throw ErrorCode.PARAM_MISS;
    }
}

