import { ormDB, userInfoSon } from "@madex/ex-ts-dao";


let _ = require('lodash');


export async function getFatherUserId(user_id: number | any) {
    let dbInfo = await userInfoSon.prototype.findOne({
        where: {
            user_id: user_id
        },
        raw: true
    });
    return dbInfo ? dbInfo.father_id : null
}

export async function getUidsByFatherUid(father_user_id: number) {
    let dbInfoList = await userInfoSon.prototype.findAll({
        where: {
            father_id: father_user_id
        },
        raw: true
    });
    return dbInfoList.length ? dbInfoList.map(item => item.user_id) : []
}



