import { ormDB, usefulLink, userMailLog, userSub } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog, } from "./userOptLog.service";
import { sendEmail } from "../../../utils/mUserUtils";
import { TYPE_MAIL } from "../../../constant/statusConst";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface UserMailLogVO {
    id?: number;

    user_id?: number;

    is_kyc?: number;

    lang?: string;

    have_money?: number;

    subject?: string,

    content?: string,

    page?: number,

    size?: number

    uidStr?: string
}


export async function history(page: number | undefined, size: number | undefined) {

    let resList = await userMailLog.prototype.findAndCount({
        limit: size,
        offset: (Number(page) - 1) * Number(size),
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}


export async function mailDetail(id: number | undefined) {

    let dbInfo = await userMailLog.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });

    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    return dbInfo;
}


export async function mailSend(userMailLogVO: UserMailLogVO, currentUserId: any, ip: string | undefined) {
    let where = {
        //TODO:0 ? 1  ???
        status: 0
    };
    if (userMailLogVO.user_id) {
        where["user_id"] = userMailLogVO.user_id
    }
    else {
        let kyc = userMailLogVO.is_kyc;
        if (kyc && (kyc == 1 || kyc == 2)) {
            where["is_kyc"] = kyc
        }
        let haveMoney = userMailLogVO.have_money;
        if (haveMoney && (haveMoney == 1 || haveMoney == 2)) {
            where["have_money"] = haveMoney
        }
        if (userMailLogVO.lang) {
            where["lang"] = userMailLogVO.lang
        }
    }

    let toAddrRes = await userSub.prototype.findAll({
        where: where,
        raw: true
    });
    if (!toAddrRes.length) {
        throw ErrorCode.DATA_NOT_EXIST
    }
    let params = {
        subject: userMailLogVO.subject,
        content: userMailLogVO.content
    }

    for (let sub of toAddrRes) {
        //TODO:老管理后台就没有模版 ？？？
        sendEmail(sub.sub, sub.user_id, "", params, userMailLogVO.lang);
    }

    let type = userMailLogVO.user_id ? TYPE_MAIL.TYPE_MAIL_LOG_SINGLE : getType(Number(userMailLogVO.is_kyc), Number(userMailLogVO.have_money));

    let insertInfo = await userMailLog.prototype.create({
        subject: userMailLogVO.subject,
        content: userMailLogVO.content,
        user_id: userMailLogVO.user_id,
        type: type,
        number: toAddrRes.length,
        createdAt: new Date(),
        updatedAt: new Date(),
    });
    //管理后台操作日志
    addOptLog(currentUserId, Number(insertInfo.user_id), '发送订阅邮件', ip, JSON.stringify(insertInfo), '邮件和PUSH');

    return insertInfo;
}


export async function maiSendGroup(subject: string, content: string, currentUserId: any, ip: string | undefined, uids: string[]) {

    let mailLogList: any = [];

    for (let uid of uids) {
        let oneUid = Number(uid);
        if (!oneUid) {
            throw ErrorCode.UID_ILLEGALITY
        }

        let insertOne = {
            subject: subject,
            content: content,
            user_id: oneUid,
            type: TYPE_MAIL.TYPE_MAIL_LOG_SINGLE,
            number: 1,
            status: -1,
            createdAt: new Date(),
            updatedAt: new Date(),
        }
        mailLogList.push(insertOne);
    }

    let partList = _.chunk(mailLogList, 100);

    let tx;
    try {
        tx = await ormDB.transaction();
        for (let onePartList of partList) {
            await userMailLog.prototype.bulkCreate(onePartList, {
                transaction: tx
            });
        }
        await tx.commit();
    }
    catch (e) {
        if (tx) {
            await tx.rollback();
        }
        logger.error(`maiSendGroup.bulkCreate.error:` + e);
    }
    //管理后台操作日志
    addOptLog(currentUserId, 0, '群发邮件', ip, `主题:${JSON.stringify(subject)},用户:${uids}`, '邮件和PUSH');

    return "success"
}

function getType(isKyc: number, haveMoney: number) {
    if (haveMoney == 1 && isKyc == 1) {
        return 1;
    }
    if (haveMoney == 1 && isKyc == 2) {
        return 2;
    }
    if (haveMoney == 2 && isKyc == 1) {
        return 3;
    }
    if (haveMoney == 2 && isKyc == 2) {
        return 4;
    }
    return 5;
}

