// ts 库
// ts 的 dao 代码在 @broker/nodejs_dao 的 ts 分支上
import { user } from "@broker/nodejs_dao_next";

// 可以直接引用原有 js 封装的工具, 但是目前 js 的库没有类型提示
// 后面吧 common 用 ts 改一下就行了
import { redisUtils } from "@broker/nodejs_common";

export interface UserPayload {
    email: string;

    name: string;

    user_id: string;
}

export const getUserInfo = async (payload: UserPayload) => {
    const key = "ts-api-demo:user"
    const result = await redisUtils.getSync(key)
    if (result) {
        return {
            user: result
        }
    }
    const dbUser = await user.prototype.findOne({
        where: {
            id: payload.user_id
        },
        raw: true
    });
    if (dbUser) {
        await redisUtils.writeSync(key, dbUser, 5)
    }
    return {
        user: dbUser
    }
};

