import {
    ormDB,
    userInfoSon,
    feeRateContractLog,
    contractPairs
} from "@madex/ex-ts-dao";
import { FEE_RATE_LOG_STATUS } from "../../src/constant/feeRateLogConst";
import { changeUserContractFee, isWhiteListUser } from "../model/task.fee.rate.log.model";

const schedule = require('node-schedule');
const { logger, daoType } = require('@madex/ex-js-public');

let fee_rate_contract_log = feeRateContractLog.prototype;
let feeRateCheckStatus = FEE_RATE_LOG_STATUS;
let user_info_son = userInfoSon.prototype;
let Op = ormDB.Op;

const oneHour = 1000 * 60 * 60;
const oneDay = oneHour * 24;
const oneMonth = oneDay * 30;


let inJob = false;
let limit = 3000;



let setFeeRateJob = schedule.scheduleJob('*/30 * * * * *', function () {
    if (inJob) {
        return;
    }
    inJob = true;
    doJob().catch(err => {
        logger.warn('setFeeRateJob', err);
    }).then(() => {
        inJob = false;
    });
});


let setDefaultRun = false;
let setExpiredDefaultJob = schedule.scheduleJob('*/5 * * * *', function () {
    logger.info(' contract setExpiredDefaultJob run ', new Date().toISOString());
    if (setDefaultRun) {
        return;
    }
    setDefaultRun = true;
    setExpiredDefault().then(res => {
        setDefaultRun = false;
    }).catch(err => {
        setDefaultRun = false;
        logger.warn('contract  setFeeRateJob', err);
    })
});


let doJob = async function () {
    let ctm = new Date();
    let dblogs = await fee_rate_contract_log.findAll({
        where: {
            is_check: 0,
            beginAt: { [Op.lte]: ctm },
            expireAt: { [Op.gte]: ctm },
        },
        limit: limit,
        raw: true,
    });

    for (let i = 0; i < dblogs.length; i++) {

        if (await isWhiteListUser(dblogs[i].user_id) && dblogs[i].comment && dblogs[i].comment.indexOf('到期') != -1) {
            continue;
        }

        if (Number(dblogs[i].maker_fee) < 0 && (Math.abs(Number(dblogs[i].maker_fee)) > Math.abs(Number(dblogs[i].taker_fee)))) {
            continue;
        }

        await changeOneFee(dblogs[i]);
    }
    await removeOldLog();
};


let changeOneFee = async function (dblog) {
    let transaction;
    return changeUserContractFee(dblog.user_id, dblog.pair, dblog.fee_model, dblog.maker_fee, dblog.taker_fee, dblog.id
    ).then(async res => {
        if (!res) {
            throw 'changeUserFee fail';
        }

        let dbsons = await user_info_son.findAll({
            attributes: ['user_id', 'type'],
            where: {
                father_id: dblog.user_id,
                // status: userInfoSon.STATUS.NORMAL,  // 量化交易内部创建的账号需要变更手续费;
            },
            raw: true,
        });
        let son_fee_rate: any = [];
        for (let i = 0; i < dbsons.length; i++) {
            let son = dbsons[i];
            son_fee_rate.push({

                user_id: son.user_id,
                pair: dblog.pair,
                fee_model: dblog.fee_model,
                maker_fee: dblog.maker_fee,
                taker_fee: dblog.taker_fee,
                beginAt: new Date(),
                expireAt: dblog.expireAt,
                is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
                comment: '继承父账户费率',
            });
        }

        transaction = await ormDB.transaction();
        await fee_rate_contract_log.update({ // 将当前生效中的值置为过期
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
        }, {
            where: {
                user_id: dblog.user_id,
                pair: dblog.pair,
                is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE,
            },
            transaction: transaction,
        });
        await fee_rate_contract_log.update({
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE,
        }, {
            where: {
                id: dblog.id,
                user_id: dblog.user_id,
                pair: dblog.pair,
                is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
            },
            transaction: transaction,
        });
        if (son_fee_rate.length > 0) {
            await fee_rate_contract_log.bulkCreate(son_fee_rate, {
                transaction: transaction,
            });
        }
        await transaction.commit();
        transaction = null;
    }).catch(async err => {
        if (transaction) {
            await transaction.rollback();
            transaction = null;
        }
        logger.warn('setFeeRateJob.changeOneFee', dblog, err);
    });
};


let removeOldLog = async function () {
    let ctm = Date.now();
    let etm = new Date(ctm - 1000 * 60 * 60 * 24 * 31);
    await fee_rate_contract_log.destroy({
        where: {
            is_check: {
                [Op.in]: [
                    feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
                    feeRateCheckStatus.CHECK_STATUS_DELETED,
                ]
            },
            updatedAt: { [Op.lt]: etm },
        }
    });
};


// 过期费率处理
async function setExpiredDefault() {
    let comment = '费率到期系统自动调整为基础费率';
    let ctm = new Date(Date.now() - oneDay); // 已经过期;
    let expirdFees = await fee_rate_contract_log.findAll({
        attributes: ['user_id', 'pair', 'fee_model', 'maker_fee', 'taker_fee'],
        where: {
            is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE, // 正在生效中的
            expireAt: { [Op.lte]: ctm },
        },
        limit: 500, // 后边处理插入时可以单次插入
        raw: true,
    });
    if (expirdFees.length == 0) return;
    let expiredUsers: any = [];
    for (let i = 0; i < expirdFees.length; i++) {
        expiredUsers.push(expirdFees[i].user_id);
    }
    let uncheckCounts = await fee_rate_contract_log.findAll({
        attributes: [[ormDB.literal('count(1)'), 'amount'], 'user_id'],
        where: {
            user_id: expiredUsers,
            is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
            beginAt: { [Op.lte]: new Date() },
            comment,
        },
        raw: true,
        group: ['user_id'],
    });
    let unCheckCountObj = {};
    for (let i = 0; i < uncheckCounts.length; i++) {
        let { user_id, amount } = uncheckCounts[i];
        unCheckCountObj[user_id] = amount;
    }

    let init_maker_rate = 1, init_taker_rate = 1;  // maker_fee 和 taker_fee 同时为1 代表初始化用户费率

    let newFeeArr: any = [];
    let beginAt = new Date();
    for (let i = 0; i < expirdFees.length; i++) {
        let { pair, fee_model, user_id, maker_fee: before_maker_fee, taker_fee: before_taker_fee } = expirdFees[i];

        if (await isWhiteListUser(user_id)) {
            continue;
        }
        if (unCheckCountObj[user_id] > 0) { // 已经存在
            continue;
        }
        newFeeArr.push({
            user_id,
            pair: pair,
            fee_model,
            maker_fee: init_maker_rate,
            taker_fee: init_taker_rate,
            beginAt: beginAt,
            expireAt: new Date(beginAt.getTime() + oneMonth),
            is_check: feeRateCheckStatus.CHECK_STATUS_UNCHECK,
            comment,
        });
    }
    // 如果有活动,采用活动的费率
    if (newFeeArr.length > 0) {
        let trans: any;
        try {
            trans = await ormDB.transaction();
            await fee_rate_contract_log.update({
                is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE_OVER,
            }, {
                where: {
                    user_id: expiredUsers,
                    is_check: feeRateCheckStatus.CHECK_STATUS_ACTIVE, // 正在生效中的
                    expireAt: { [Op.lte]: ctm },
                },
                transaction: trans,
            });
            await fee_rate_contract_log.bulkCreate(newFeeArr, {
                transaction: trans,
            });
            await trans.commit();
            trans = null;
        }
        catch (error) {
            if (trans) {
                trans.rollback();
            }
        }
    }
}
