import * as abkFeeStatisticsService from "../../service/v2/abkFeeStatistics.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../../constant/errorCode";
import { beforeQueryCheckTime, CommonParam, setPageAndSize } from "../../service/v2/abkCommonService";

/**
 * 首页数据概览
 * @param req
 * @param commonParam
 */
export const gatherData = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.gatherData";
    try {
        beforeQueryCheckTime(commonParam);
        let res = await abkFeeStatisticsService.gatherData(commonParam.from_time, commonParam.to_time,commonParam.query_except_fee);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 查询手续费数据
 * query_type 1 现货 2 U本位合约 3 币本位合约 4 全部(包含提现)
 * @param req
 * @param commonParam
 */
export const getFeeData = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.getFeeData";
    try {
        setPageAndSize(commonParam);
        beforeQueryCheckTime(commonParam);
        let type = Number(commonParam.query_type) || 4;
        let res = await abkFeeStatisticsService.getFeeData(commonParam.from_time, commonParam.to_time, commonParam.page, commonParam.size, type);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 查询手续费数据详情（分用户）
 * query_type 1 现货 2 U本位合约 3 币本位合约 4 全部(不含提现，提现单独接口)
 * user_type 用户类型:1:普通用户;2:代理用户(crm用户)
 * @param req
 * @param commonParam
 */
export const getFeeDataDetails = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.getFeeDataDetails";
    try {
        setPageAndSize(commonParam);
        if (!commonParam.from_time) {
            throw ErrorCode.PARAM_MISS;
        }
        let type = Number(commonParam.query_type) || 4;
        let user_type = Number(commonParam.user_type) || 1;
        let user_id = Number(commonParam.user_id || 0);
        let res = await abkFeeStatisticsService.getFeeDataDetails(commonParam.from_time, commonParam.to_time, commonParam.page, commonParam.size, type, user_type, user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 提现手续费
 * @param req
 * @param commonParam
 */
export const withdrawData = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.withdrawData";
    try {
        setPageAndSize(commonParam);
        beforeQueryCheckTime(commonParam);
        let res = await abkFeeStatisticsService.withdrawData(commonParam.from_time, commonParam.to_time, commonParam.page, commonParam.size);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 提现手续费详情
 * @param req
 * @param commonParam
 */
export const withdrawDataDetails = async (req: any, commonParam: CommonParam) => {
    let func_name = "abkFeeStatistics.control.withdrawDataDetails";
    try {
        setPageAndSize(commonParam);
        let user_id = Number(commonParam.user_id || 0);
        let res = await abkFeeStatisticsService.withdrawDataDetails(commonParam.from_time, commonParam.to_time, commonParam.page, commonParam.size, user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



