/**
 * Madex 管理后台路由
 */
import Express from "express"

const {
    Res3Utils,
    logger,
} = require("@madex/ex-js-public");
const router = Express.Router();


import * as userController from "../../mvc/control/user.control";
import * as i18nCtrl from "../../mvc/control/i18n.control";
import * as i18nLogCtrl from "../../mvc/control/i18nlog.control";
import * as  aclUserCtrl from "../../mvc/control/aclUser.control";
import * as  aclRoleAuthCtrl from "../../mvc/control/aclRoleAuth.control";
import * as  userOptCtrl from "../../mvc/control/userOpt.control";
import * as  userAuthConfigCtrl from "../../mvc/control/userAuthConfig.control";
import * as  hotPairConfigCtrl from "../../mvc/control/hotPairConfig.control";
import * as ReqUtils from "../../../utils/req-utils";

import * as spotPairCtrl from "../../mvc/control/spotPair.control";
import * as coinTypeCtrl from "../../mvc/control/coinType.control";
import * as noticeCtrl from "../../mvc/control/notice.control";
import * as airdropCtrl from "../../mvc/control/airdrop.control";

import * as mUserManageCtrl from "../../mvc/control/mUserManage.control";
import * as mUserRealNameCtrl from "../../mvc/control/mUserRealName.control";
import * as usefulLinkCtrl from "../../mvc/control/usefulLink.control";
import * as mUserSubscribeCtrl from "../../mvc/control/mUserSubscribe.control";
import * as commonUserFeeSettingCtrl from "../../mvc/control/commonUserFeeSetting.control";
import * as mUserAssetsCtrl from "../../mvc/control/mUserAssets.control";
import * as departmentCtrl from "../../mvc/control/aclDepartment.control";
import * as positionCtrl from "../../mvc/control/aclPosition.control";
import * as orderPendingAndHistoryCtrl from "../../mvc/control/mUserOrderPendingAndHistory.control";
import * as appVersionCtrl from "../../mvc/control/appVersion.control";
import * as appApplyVersionCtrl from "../../mvc/control/appApplyVersion.control";
import * as appDynamicDomainCtrl from "../../mvc/control/appDynamicDomain.control";
import * as appSpecialModelCtrl from "../../mvc/control/appSpecialModel.control";
import * as appFeatureCtrl from "../../mvc/control/appFeature.control";
import * as systemTriggerCtrl from "../../mvc/control/systemTrigger.control";
import * as apikeyStrictCtrl from "../../mvc/control/apikeyStrict.control";
import * as contractPairCtrl from "../../mvc/control/contractPair.control";
import * as spotMarketMakerCtrl from "../../mvc/control/spotMarketMaker.control";
import * as contractMarketMakerCtrl from "../../mvc/control/contractMarketMaker.control";
import * as contractLimitTradeCtrl from "../../mvc/control/contractLimitTrade.control";
import * as contractAgentCtrl from "../../mvc/control/contractAgent.control";
import * as depositAndWithdrawCtrl from "../../mvc/control/depositAndWithdraw.control";
import * as coinTypeApplyCtrl from "../../mvc/control/coinTypeApply.control";
import * as pairApplyCtrl from "../../mvc/control/pairApply.control";
import * as cronApplyCtrl from "../../mvc/control/cronApply.control";
import * as spotDataCtrl from "../../mvc/control/spotData.control";
import * as exBusinessAreaCtrl from "../../mvc/control/exBusinessArea.control";
import * as rewardTimePeriodCtrl from "../../mvc/control/rewardTimePeriod.control";
import * as collateralCtrl from "../../mvc/control/collateral.control";
import * as fianceAccountCtrl from "../../mvc/control/fianceAccount.control";
import * as fianceAccountCategoryCtrl from "../../mvc/control/fianceAccountCategory.control";
import * as billsCtrl from "../../mvc/control/mUserBills.control";

const getFunc = {
    'user/info': userController.getUserInfo,
};

const postFunc = {
    //技术部-其他管理-国际化管理
    'i18n/info/list': i18nCtrl.list,//当前版本信息列表
    'i18n/info/add': i18nCtrl.add,//发布版本
    'i18n/info/preview': i18nCtrl.preview,//发布版本-预览
    'i18n/info/version/list': i18nCtrl.versionList,//版本列表
    'i18n/info/history/list': i18nLogCtrl.list,//历史版本信息列表
    'i18n/info/history/revert': i18nLogCtrl.revert,//版本回退
    'i18n/info/check/list': i18nCtrl.checkList,//检测列表（语言有为空的）
    //金融部-交易管理-交易对配置
    'spotPair/save': spotPairCtrl.save,//新增
    'spotPair/update': spotPairCtrl.update,//修改
    'spotPair/list': spotPairCtrl.list,
    'spotPair/pushToCoreSystem': spotPairCtrl.pushToCoreSystem,
    'spotPair/getAllSubmitSuccess': spotPairCtrl.getAllSubmitSuccess,
    //金融部-交易管理-合约代码配置
    'contractPair/save': contractPairCtrl.save,//新增
    'contractPair/update': contractPairCtrl.update,//修改
    'contractPair/list': contractPairCtrl.list,
    'contractPair/pushToCoreSystem': contractPairCtrl.pushToCoreSystem,
    'contractPair/getAllSubmitSuccess': contractPairCtrl.getAllSubmitSuccess,

    //运营部-其他管理-币种管理
    'coinType/save': coinTypeCtrl.save,
    'coinType/update': coinTypeCtrl.update,
    'coinType/list': coinTypeCtrl.list,
    'coinType/pushToCoreSystem': coinTypeCtrl.pushToCoreSystem,
    'coinType/getAllSubmitSuccess': coinTypeCtrl.getAllSubmitSuccess,
    'coinType/audit': coinTypeCtrl.audit,
    'coinType/mixinCoinList': coinTypeCtrl.mixinCoinList,
    'coinType/nftList': coinTypeCtrl.nftList,

    'coinType/chainList': coinTypeCtrl.chainList,
    'coinType/updateIconUrl': coinTypeCtrl.updateIconUrl,


    //权限管理 - 我的权限
    'user/getInfo': userOptCtrl.getInfo,
    'user/getInfoByUserId': userOptCtrl.getInfoByUserId,
    'user/getInfoDetailByUserId': userOptCtrl.getInfoDetailByUserId,
    //权限管理 - 组织结构
    'department/pageList': departmentCtrl.pageList,
    'department/allList': departmentCtrl.allList,
    'department/getDepartmentTree': departmentCtrl.getDepartmentTree,
    'department/add': departmentCtrl.add,
    'department/update': departmentCtrl.update,
    'department/del': departmentCtrl.del,
    'department/userList/dpIdsOrAccount': departmentCtrl.getUserList,
    'position/allList': positionCtrl.allList,

    //权限管理 - 后台角色管理
    'acl/role/list': aclRoleAuthCtrl.roleList,
    'acl/role/getByUser': aclRoleAuthCtrl.getRoleByUser,
    'acl/role/getAll': aclRoleAuthCtrl.getAllRole,
    'acl/role/save': aclRoleAuthCtrl.saveRole,
    'acl/role/del': aclRoleAuthCtrl.delRole,
    //'acl/changeRoleAuth': aclRoleAuthCtrl.changeRoleAuth,
    'acl/auth/list': aclRoleAuthCtrl.authList,
    'acl/auth/tree': aclRoleAuthCtrl.getAuthTree,
    'acl/auth/getByUser': aclRoleAuthCtrl.getAuthByUser,
    'acl/auth/getByRole': aclRoleAuthCtrl.getAuthByRole,
    'acl/auth/save': aclRoleAuthCtrl.saveAuth,
    'acl/auth/del': aclRoleAuthCtrl.delAuth,

    //权限管理 - 后台用户管理
    'acl/user/add': aclUserCtrl.add,
    'acl/user/list': aclUserCtrl.list,
    'acl/user/update': aclUserCtrl.update,
    'acl/user/checkTotpCode': aclUserCtrl.checkTotpCode,
    'acl/changeUserRole': aclRoleAuthCtrl.changeUserRole,
    'acl/user/opt/log/list': aclUserCtrl.optLogList,

    'user/login': userOptCtrl.login,
    'user/logout': userOptCtrl.logout,
    'user/login/confirm': userOptCtrl.loginConfirm,
    'user/bind/totp/ask': userOptCtrl.bindTotpAsk,
    'user/bind/totp/confirm': userOptCtrl.bindTotpConfirm,
    'user/auth/reset/totp': userAuthConfigCtrl.resetTotp,

    //运营部-其他管理-热门交易对搜索
    'hot/pair/config/list': hotPairConfigCtrl.list,
    'hot/pair/config/add': hotPairConfigCtrl.add,
    'hot/pair/config/update': hotPairConfigCtrl.update,
    'hot/pair/config/del': hotPairConfigCtrl.del,

    //运营部-其他管理-消息通知
    'notice/list': noticeCtrl.list,
    'notice/add': noticeCtrl.add,
    'notice/update': noticeCtrl.update,


    //客服部-用户管理
    'mUser/manage/userList': mUserManageCtrl.userList,//Madex 用户管理 ->用户列表
    'mUser/manage/oneUserDetail': mUserManageCtrl.oneUserDetail,//Madex 用户管理 ->单个用户详情
    'mUser/manage/updateUserEmail': mUserManageCtrl.updateUserEmail,//Madex 用户管理 ->修改用户邮箱
    'mUser/manage/lockAccount': mUserManageCtrl.lockAccount,//Madex 用户管理 ->锁定账户
    'mUser/manage/unlockAccount': mUserManageCtrl.unlockAccount,//Madex 用户管理 ->解锁账户
    'mUser/manage/clearLoginLimit': mUserManageCtrl.clearLoginLimit,//Madex 用户管理 ->清除登陆限制
    'mUser/manage/clear24WithdrawLimit': mUserManageCtrl.clear24WithdrawLimit,//Madex 用户管理 ->清除24小时提现限制
    'mUser/manage/kyc/list': mUserRealNameCtrl.kycList,//Madex 用户管理 ->实名认证列表
    'mUser/manage/kyc/oneDetail': mUserRealNameCtrl.oneDetail,//Madex 用户管理 ->kyc详情
    'mUser/manage/kyc/audit': mUserRealNameCtrl.audit,//Madex 用户管理 ->kyc审核
    'mUser/manage/kyc/auditors': mUserRealNameCtrl.auditors,//Madex 用户管理 -> 所有审核人员
    'mUser/manage/walletAsset/detail': mUserAssetsCtrl.walletAssetDetail,//Madex 用户管理 ->钱包账户资产详情
    'mUser/manage/asset/distribution': mUserAssetsCtrl.assetDistribution,//Madex 用户管理 ->资产分布
    'mUser/manage/tradeAsset/detail': mUserAssetsCtrl.tradeAssetsDetail,//Madex 用户管理 ->交易账户资产详情
    'mUser/manage/deposit/list': mUserAssetsCtrl.depositList,//Madex 用户管理 -> 充值记录
    'mUser/manage/withdraw/list': mUserAssetsCtrl.withdrawList,//Madex 用户管理 -> 提现记录
    'mUser/manage/order/pending/list': orderPendingAndHistoryCtrl.pendingList,//Madex 用户管理 ->当前委托
    'mUser/manage/order/history/list': orderPendingAndHistoryCtrl.historyList,//Madex 用户管理 ->历史委托
    'mUser/manage/order/detail/list': orderPendingAndHistoryCtrl.detailList,//Madex 用户管理 ->成交记录
    'mUser/manage/withdrawLock': mUserManageCtrl.withdrawLock,//Madex 用户管理 -> 锁定提现
    'mUser/manage/withdrawUnlock': mUserManageCtrl.withdrawUnlock,//Madex 用户管理 -> 解除锁定提现
    'mUser/manage/clearTotp': mUserManageCtrl.clearTotp,//Madex 用户管理 -> 清除谷歌
    'mUser/manage/billTypeList': billsCtrl.billTypeList,//账单类型列表
    'mUser/manage/billDetailList': billsCtrl.billDetailList,//账单详情

    //运营部-现货-资源位管理
    'link/useful/list': usefulLinkCtrl.list,//链接记录列表
    'link/useful/add': usefulLinkCtrl.add,//添加链接记录
    'link/useful/delete': usefulLinkCtrl.del,//删除链接记录
    'link/useful/update': usefulLinkCtrl.update,//修改链接记录
    'link/useful/detail': usefulLinkCtrl.detail,//链接记录详情

    //运营部-其他管理-邮件订阅
    'mUser/subscribe/list': mUserSubscribeCtrl.list,//订阅列表
    'mUser/subscribe/delete': mUserSubscribeCtrl.del,//删除订阅
    'mUser/subscribe/count': mUserSubscribeCtrl.count,//订阅统计
    'mUser/subscribe/mail/history': mUserSubscribeCtrl.history,//发送历史
    'mUser/subscribe/mail/send': mUserSubscribeCtrl.mailSend,//邮件发送
    'mUser/subscribe/mail/detail': mUserSubscribeCtrl.mailDetail,//发送详情
    'mUser/subscribe/mail/send/group': mUserSubscribeCtrl.maiSendGroup,//群发邮件

    //运营部-现货-VIP管理(普通用户手续费、市商手续费)
    'mUser/fee/setting/list': commonUserFeeSettingCtrl.list,//普通用户手续费列表
    'mUser/fee/setting/add': commonUserFeeSettingCtrl.add,//新增普通用户手续费
    'mUser/fee/setting/update': commonUserFeeSettingCtrl.update,//修改普通用户手续费
    'mUser/fee/setting/delete': commonUserFeeSettingCtrl.del,//删除普通用户手续费
    //'mUser/fee/setting/submit': commonUserFeeSettingCtrl.submit,//提交普通用户手续费
    'mUser/fee/vip/level/list': commonUserFeeSettingCtrl.vipLevelList,//用户等级费率列表

    //技术部-App管理-App版本管理
    'tech/app/version/list': appVersionCtrl.list,
    'tech/app/version/add': appVersionCtrl.add,
    'tech/app/version/update': appVersionCtrl.update,
    //技术部-App管理-App首页入口管理
    'tech/app/feature/list': appFeatureCtrl.list,
    'tech/app/feature/add': appFeatureCtrl.add,
    'tech/app/feature/update': appFeatureCtrl.update,
    'tech/app/feature/del': appFeatureCtrl.del,
    //技术部-App管理-App审核管理
    'tech/app/apply/version/list': appApplyVersionCtrl.list,
    'tech/app/apply/version/modify': appApplyVersionCtrl.modify,
    //技术部-App管理-App动态域名
    'tech/app/dynamic/domain/get': appDynamicDomainCtrl.get,
    'tech/app/dynamic/domain/update': appDynamicDomainCtrl.update,
    //技术部-App管理-App特定机型配置
    'tech/app/special/model/get': appSpecialModelCtrl.get,
    'tech/app/special/model/update': appSpecialModelCtrl.update,
    //技术部-其他管理-触发配置管理
    'tech/other/system/trigger/list': systemTriggerCtrl.list,
    'tech/other/system/trigger/add': systemTriggerCtrl.add,
    'tech/other/system/trigger/update': systemTriggerCtrl.update,
    'tech/other/system/trigger/del': systemTriggerCtrl.del,
    //技术部-其他管理-API限速管理
    'tech/other/apikey/strict/list': apikeyStrictCtrl.list,
    'tech/other/apikey/strict/add': apikeyStrictCtrl.add,
    'tech/other/apikey/strict/update': apikeyStrictCtrl.update,
    'tech/other/apikey/strict/del': apikeyStrictCtrl.del,

    //金融部-其他管理-现货做市参数配置
    'fiance/other/spot/market/maker/set': spotMarketMakerCtrl.set,
    'fiance/other/spot/market/maker/list': spotMarketMakerCtrl.list,
    'fiance/other/spot/market/maker/param/get': spotMarketMakerCtrl.paramGet,
    'fiance/other/spot/market/maker/param/set': spotMarketMakerCtrl.paramSet,
    //金融部-其他管理-合约做市参数配置
    'fiance/other/contract/market/maker/set': contractMarketMakerCtrl.set,
    'fiance/other/contract/market/maker/list': contractMarketMakerCtrl.list,
    'fiance/other/contract/market/maker/param/get': contractMarketMakerCtrl.paramGet,
    'fiance/other/contract/market/maker/param/set': contractMarketMakerCtrl.paramSet,
    //金融部-其他管理-合约限制交易配置
    'fiance/other/contract/limit/trade/set': contractLimitTradeCtrl.set,
    'fiance/other/contract/limit/trade/list': contractLimitTradeCtrl.list,
    //金融部-其他管理-合约接单账户配置(代理商)
    'fiance/other/contract/agent/set': contractAgentCtrl.agentSet, // 参数 user_id agent_id agent_id 只能为0(删除代理关系) 或者和user_id同值
    'fiance/other/contract/agent/list': contractAgentCtrl.agentList, // 可以传1000 全捞出来 参数支持user_id 或者 agent_id 返回值只有user_id agent_id 时间
    'fiance/other/contract/agent/hedgeRatio/set': contractAgentCtrl.hedgeRatioSet, // 新增 給代理商添加对冲配置参数 agent_id product(合约交易对) ratio对冲比例0-1之间
    'fiance/other/contract/agent/hedgeRatio/list': contractAgentCtrl.hedgeRatioList, // 新增 返回值返回list里面 product交易对 ratio对冲比例 qty 对冲数量

    //金融部-其他管理-合约接单账户关联(代理用户)
    'fiance/other/contract/agent/user/set': contractAgentCtrl.agentUserSet, // 参数user_id agent_id agent为0(删除代理关系)
    'fiance/other/contract/agent/user/list': contractAgentCtrl.agentUserList, // 参数支持user_id 或者 agent_id 返回值只有user_id agent_id 时间
    //金融部-其他管理-合约渠道用户管理(代理商渠道)
    'fiance/other/contract/agent/channel/set': contractAgentCtrl.agentChannelSet,
    'fiance/other/contract/agent/channel/list': contractAgentCtrl.agentChannelList,

    //金融部-其他管理-币种抵扣
    'fiance/other/contract/collateral/list': collateralCtrl.list, // 列出全部
    'fiance/other/contract/collateral/save': collateralCtrl.save,  // 新增或者修改

    //客服部-资金管理-充值管理
    'custom/fund/deposit/record/list': depositAndWithdrawCtrl.depositList,
    //客服部-资金管理-提现管理
    'custom/fund/withdraw/record/list': depositAndWithdrawCtrl.withdrawList,

    //技术部-上币管理-上币申请
    'tech/apply/new/coin/list': coinTypeApplyCtrl.list,//申请上新币列表
    'tech/apply/new/coin/apply': coinTypeApplyCtrl.apply,//申请上新币
    'tech/apply/new/coin/apply/cancel/self': coinTypeApplyCtrl.cancelSelf,//撤销申请上新币
    'tech/apply/new/coin/apply/edit': coinTypeApplyCtrl.edit,//编辑申请上新币
    'tech/apply/new/coin/apply/review': coinTypeApplyCtrl.review,//审核申请上新币
    'tech/apply/new/coin/apply/rewrite': coinTypeApplyCtrl.rewrite,//驳回申请上新币
    'tech/apply/new/coin/apply/cancel': coinTypeApplyCtrl.cancel,//管理员取消申请上新币
    'tech/apply/new/coin/explore/url/list': coinTypeApplyCtrl.exploreUrlList,//交易浏览器列表
    'tech/apply/new/coin/listed': coinTypeApplyCtrl.listed,//已有币种列表
    //技术部-交易上下线管理-申请上新交易对
    'tech/apply/new/pair/list': pairApplyCtrl.list,//申请上交易对列表
    'tech/apply/new/pair/apply': pairApplyCtrl.apply,//申请上新交易对
    'tech/apply/new/pair/apply/cancel/self': pairApplyCtrl.cancelSelf,//撤销申请上新交易对
    'tech/apply/new/pair/apply/edit': pairApplyCtrl.edit,//编辑申请上新交易对
    'tech/apply/new/pair/apply/review': pairApplyCtrl.review,//审核申请上新交易对
    'tech/apply/new/pair/apply/rewrite': pairApplyCtrl.rewrite,//驳回申请上新交易对
    'tech/apply/new/pair/apply/cancel': pairApplyCtrl.cancel,//管理员取消申请上新交易对
    //'tech/apply/new/pair/trade/area/list': pairApplyCtrl.tradeAreaList,//已有交易区列表
    //'tech/apply/new/pair/listed': pairApplyCtrl.listed,//已有交易对列表
    //技术部-交易上下线管理-申请审核定时器
    'tech/apply/new/cron/list': cronApplyCtrl.list,//审核上币定时器信息列表
    'tech/apply/new/cron/delete': cronApplyCtrl.del,//删除审核上币定时器
    'tech/apply/new/cron/pair/add/active': cronApplyCtrl.addPairActive,//增加激活交易对定时器
    'tech/apply/new/cron/pair/add/hide': cronApplyCtrl.addPairHide,//增加隐藏交易对定时器
    'tech/apply/new/cron/coin/add/deposit': cronApplyCtrl.addDeposit,//增加新币充值定时器
    'tech/apply/new/cron/coin/add/withdraw': cronApplyCtrl.addWithdraw,//增加新币提现定时器
    //运营部-现货-现货数据
    'operate/spot/data/increase/user/list': spotDataCtrl.increaseUserList,
    'operate/spot/data/trade/user/list': spotDataCtrl.tradeUserList,
    'operate/spot/data/active/user/list': spotDataCtrl.activeUserList,
    'operate/spot/data/user/deposit/list': spotDataCtrl.userDepositList,
    'operate/spot/data/user/withdraw/list': spotDataCtrl.userWithdrawList,
    'operate/spot/data/user/depositAndWithdraw/list': spotDataCtrl.userDepositAndWithdrawList,
    'operate/spot/data/user/gatherData': spotDataCtrl.gatherData,

    //运营部-其他管理-交易区设置
    'operate/other/business/area/add': exBusinessAreaCtrl.add,
    'operate/other/business/area/update': exBusinessAreaCtrl.update,
    'operate/other/business/area/delete': exBusinessAreaCtrl.del,
    'operate/other/business/area/list': exBusinessAreaCtrl.list,
    'operate/other/business/area/getTree': exBusinessAreaCtrl.getTree,
    //币种所属交易区设置
    'operate/other/business/area/router/add': exBusinessAreaCtrl.routerAdd,
    'operate/other/business/area/router/update': exBusinessAreaCtrl.routerUpdate,
    'operate/other/business/area/router/delete': exBusinessAreaCtrl.routerDel,
    'operate/other/business/area/router/list': exBusinessAreaCtrl.routerList,
    //技术部-其他管理-返佣时间配置
    'tech/other/reward/time/period/set': rewardTimePeriodCtrl.set,
    'tech/other/reward/time/period/get': rewardTimePeriodCtrl.get,
    //金融部-其他管理-账户管理
    'fiance/other/account/category/list': fianceAccountCategoryCtrl.list,
    'fiance/other/account/category/add': fianceAccountCategoryCtrl.add,
    'fiance/other/account/category/update': fianceAccountCategoryCtrl.update,
    'fiance/other/account/category/del': fianceAccountCategoryCtrl.del,

    'fiance/other/account/list': fianceAccountCtrl.list,
    'fiance/other/account/add': fianceAccountCtrl.add,
    'fiance/other/account/update': fianceAccountCtrl.update,
    'fiance/other/account/del': fianceAccountCtrl.del,

    'fiance/other/account/addInitAsset': fianceAccountCtrl.addInitAsset,
    'fiance/other/account/initAssetList': fianceAccountCtrl.initAssetList,


    //运营部-活动管理-Launchpool
    'launchpool/save': airdropCtrl.save, // Launchpool编辑
    'launchpool/list': airdropCtrl.list, // Launchpool列表
    'launchpool/prizeList': airdropCtrl.prizeList // Launchpool奖励列表

};

// TODO 这里先和 nodejs 的注册路由方式保持一样，后面在调整。

router.get('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!getFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.query, getFunc[path]);
});

router.post('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!postFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param, res).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.error(_func_name_, err);
        return Res3Utils.responseError(err, res);
    });
};

export const apiRouterV1 = router;
