import * as assetCheckService from "../../service/v2/assetCheck.service";
import { CommonParam, setPageAndSize,beforeQueryCheckTime } from "../../service/v2/abkCommonService";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../../constant/errorCode";

/**
 * 用户地址列表
 * @param req
 * @param commonParam
 */
export const userAddrList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.userAddrList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.userAddrList(commonParam.page, commonParam.size, commonParam.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 资产分布
 * @param req
 * @param commonParam
 */
export const assetDetails = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.assetDetails";
    try {
        setPageAndSize(commonParam);
        if (!commonParam.user_id) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await assetCheckService.assetDetails(commonParam.page, commonParam.size, commonParam.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 站内资金
 * @param req
 * @param commonParam
 */
export const siteAssets = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.siteAssets";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.siteAssets(commonParam.page, commonParam.size);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 站内资金
 * @param req
 * @param commonParam
 */
export const siteAssetsDetails = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.siteAssetsDetails";
    try {
        if (!commonParam.asset_id) {
            throw ErrorCode.PARAM_MISS;
        }
        let res = await assetCheckService.siteAssetsDetails(Number(commonParam.asset_id));
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 实时充值记录
 * @param req
 * @param commonParam
 */
export const depositList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.depositList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.depositList(commonParam.page, commonParam.size, commonParam.uid_or_addr);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 实时提现记录
 * @param req
 * @param commonParam
 */
export const withdrawList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.withdrawList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.withdrawList(commonParam.page, commonParam.size, commonParam.uid_or_addr);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 资金监控-总记录
 * @param req
 * @param commonParam
 */
export const fundingTotalRecords = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.fundingTotalRecords";
    try {
        let res = await assetCheckService.fundingTotalRecords();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 资金监控-每日记录
 * @param req
 * @param commonParam
 */
export const fundingDailyRecords = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.fundingDailyRecords";
    try {
        setPageAndSize(commonParam);
        beforeQueryCheckTime(commonParam);
        let res = await assetCheckService.fundingDailyRecords(commonParam);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



/**
 * 自动对账列表
 * @param req
 * @param commonParam
 */
export const autoCheckList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.fundingDailyRecords";
    try {
        let res = await assetCheckService.autoCheckList();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};



/**
 * 钱包流入流出列表
 * @param req
 * @param commonParam
 */
export const walletInOutList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.walletInOutList";
    try {
        setPageAndSize(commonParam);
        beforeQueryCheckTime(commonParam);
        let res = await assetCheckService.walletInOutList(commonParam);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};





