'use strict';


const schedule = require('node-schedule');
let { logger, datetimeUtils } = require('@madex/ex-js-public');

import { spotPairs, ormDB, coinType,contractPairs } from "@madex/ex-ts-dao";
import { getPairFromCore, getCoinFromCore } from '../../src/utils/coreSystemUtils'


let running = false;

/**
 *  每五分钟检查一次
 */
let job = schedule.scheduleJob('*/15 * * * * ?', async function () {
    logger.info('setting sync start');

    if (!running) {
        try {
            await syncPair();
            await syncCoin();
            running = true;
            logger.info("coinAndPair sync job finish");
        }
        catch (e) {
            logger.info(e)
        }
        running = false;

    }
});

const syncPair = async () => {
    let now = new Date();
    for (const pairModel of [spotPairs,contractPairs]) {
        let res = await pairModel.prototype.findAll({
            where: {
                status: 1,
                updatedAt: { [ormDB.Op.lt]: new Date(now.getTime() - 10 * 1000) } // 10秒之前的
            },
            raw: true
        })

        for (const pair of res) {
            const { symbol, id } = pair;
            let cfg = await getPairFromCore(symbol);
            if (cfg) {
                await pairModel.prototype.update({
                    status: 2,
                    product_id: cfg.productId,
                    // price_scale: cfg["priceScale"],
                    // price_increment: cfg["priceIncrement"],
                    // quantity_scale: cfg["quantityScale"],
                    // quantity_increment: cfg["quantityIncrement"],
                    taker_fee:cfg["takerFee"],
                    maker_fee:cfg["makerFee"]
                }, {
                    where: { id, status: 1 }
                });
                logger.info(symbol, "sync config success")
            }
        }
    }



}


const syncCoin = async () => {
    let now = new Date();
    let res = await coinType.prototype.findAll({
        where: {
            is_main: 1,
            main_status: 1,
            updatedAt: { [ormDB.Op.lt]: new Date(now.getTime() - 10 * 1000) } // 10秒之前的
        },
        raw: true
    })

    for (const coin of res) {
        const { general_name: symbol, id } = coin;
        let cfg = await getCoinFromCore(symbol);
        if (cfg) {
            await coinType.prototype.update({
                main_status: 2,
                asset_id: cfg["id"],
            }, {
                where: { id, main_status: 1 }
            });
            logger.info(symbol, "sync config success")
        }
    }



}


job.invoke();
