export const FEE_TYPE = {

    /**
     * 费率类型： 币币。
     */
    FEE_TYPE_SPOT: 1,
    /**
     * 费率类型： U本位合约。
     */
    FEE_TYPE_CONTRACT: 2,

    /**
     * 费率类型： 币本位合约。
     */
    FEE_TYPE_BASE_COIN_CONTRACT: 3,
}

export const FEE_TYPE_LIST = [FEE_TYPE.FEE_TYPE_SPOT, FEE_TYPE.FEE_TYPE_CONTRACT, FEE_TYPE.FEE_TYPE_BASE_COIN_CONTRACT]

export const FEE_STATUS = {
    /**
     * 费率设置纪录状态： 已提交。
     */
    STATUS_FEE_SETTING_SUBMIT: 1,
    /**
     * 费率设置纪录状态： 已生效。
     */
    STATUS_FEE_SETTING_EFFECTED: 2,
    /**
     * 费率设置纪录状态： 已过期。
     */
    STATUS_FEE_SETTING_EXPIRE: 3,
    /**
     * 费率设置纪录状态： 已删除。
     */
    STATUS_FEE_SETTING_DELETED: 4,
}

/**
 * 普通用户手续费提交备注。
 */
export const COMMENT_USER_FEE_SUBMIT = "提交普通用户手续费";


/**
 * 市商手续费提交备注。
 */
export const COMMENT_MAKER_FEE_SUBMIT = "提交市商手续费";


/**
 * KOL手续费提交备注。
 */
export const COMMENT_KOL_FEE_SUBMIT = "提交KOL手续费";