import { aclUserOptLog } from "@madex/ex-ts-dao";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let { logger } = require('@madex/ex-js-public');


export const LogType = {
    DEFAULT: 0,//默认
    LOGIN: 1,//登陆
    ADD: 2,//添加
    UPDATE: 3,//修改
    DEL: 4,//删除
    TOTP: 5,//谷歌
    SAVE: 6,//保存（添加或修改）
    UPDATE_MUSER_EMAIL: 7,//修改 Madex 用户邮箱
    LOCK_MUSER: 8,//锁定用户
    UNLOCK_MUSER: 9,//解锁用户
    CLEAR_LOGIN_LIMIT: 10,//清除用户登陆限制
    WITHDRAW_24_LIMIT: 11,//清除用户24小时限制
    KYC_AUDIT: 12,//用户实名认证审核
}

export const addOptLog = async function (user_id: any, msg: any, type: any, fail_reason?: any, session_id?: any) {
    try {
        if ((!user_id && !session_id) || !msg) {
            throw 'user_id or session_id or msg is null'
        }
        if (!user_id) {
            user_id = await getCurrentUserId(session_id);
        }

        await aclUserOptLog.prototype.create({
            user_id: user_id,
            msg: msg,
            type: type ? type : LogType.DEFAULT,
            createdAt: new Date(),
            updatedAt: new Date(),
            fail_reason: fail_reason ? fail_reason : ''
        })
    }
    catch (e) {
        logger.error('optLogService.addOptLog.error:' + e)
    }
}