import Express from "express"

const {
    Res3Utils,
    logger,
} = require("@madex/ex-js-public");
const router = Express.Router();


import * as userController from "../../mvc/control/user.control";
import * as i18nCtrl from "../../mvc/control/i18n.control";
import * as i18nLogCtrl from "../../mvc/control/i18nlog.control";
import * as  aclUserCtrl from "../../mvc/control/aclUser.control";
import * as  aclRoleAuthCtrl from "../../mvc/control/aclRoleAuth.control";
import * as  userOptCtrl from "../../mvc/control/userOpt.control";
import * as  userAuthConfigCtrl from "../../mvc/control/userAuthConfig.control";
import * as  hotPairConfigCtrl from "../../mvc/control/hotPairConfig.control";
import * as ReqUtils from "../../../utils/req-utils";

import * as spotPairCtrl from "../../mvc/control/spotPair.control";
import * as coinTypeCtrl from "../../mvc/control/coinType.control";
import * as noticeCtrl from "../../mvc/control/notice.control";
import * as mUserManageCtrl from "../../mvc/control/mUserManage.control";
import * as mUserRealNameCtrl from "../../mvc/control/mUserRealName.control";
import * as usefulLinkCtrl from "../../mvc/control/usefulLink.control";
import * as mUserSubscribeCtrl from "../../mvc/control/mUserSubscribe.control";
import * as commonUserFeeSettingCtrl from "../../mvc/control/commonUserFeeSetting.control";
import * as mUserAssetsCtrl from "../../mvc/control/mUserAssets.control";
import * as departmentCtrl from "../../mvc/control/aclDepartment.control";
import * as positionCtrl from "../../mvc/control/aclPosition.control";
import * as orderPendingAndHistoryCtrl from "../../mvc/control/mUserOrderPendingAndHistory.control";
import * as appVersionCtrl from "../../mvc/control/appVersion.control";
import * as appApplyVersionCtrl from "../../mvc/control/appApplyVersion.control";
import * as appDynamicDomainCtrl from "../../mvc/control/appDynamicDomain.control";
import * as appSpecialModelCtrl from "../../mvc/control/appSpecialModel.control";
import * as appFeatureCtrl from "../../mvc/control/appFeature.control";
import * as systemTriggerCtrl from "../../mvc/control/systemTrigger.control";
import * as apikeyStrictCtrl from "../../mvc/control/apikeyStrict.control";
import * as contractPairCtrl from "../../mvc/control/contractPair.control";
import * as spotMarketMakerCtrl from "../../mvc/control/spotMarketMaker.control";
import * as contractMarketMakerCtrl from "../../mvc/control/contractMarketMaker.control";
import * as contractLimitTradeCtrl from "../../mvc/control/contractLimitTrade.control";
import * as contractAgentCtrl from "../../mvc/control/contractAgent.control";
import * as depositAndWithdrawCtrl from "../../mvc/control/depositAndWithdraw.control";
import * as coinTypeApplyCtrl from "../../mvc/control/coinTypeApply";
import * as pairApplyCtrl from "../../mvc/control/pairApply";

const getFunc = {
    'user/info': userController.getUserInfo,
};

const postFunc = {
    //技术部-其他管理-国际化管理
    'i18n/info/list': i18nCtrl.list,
    'i18n/info/add': i18nCtrl.add,
    'i18n/info/update': i18nCtrl.update,
    'i18n/info/del': i18nCtrl.del,
    'i18n/info/log/list': i18nLogCtrl.list,
    'i18n/info/log/revert': i18nLogCtrl.revert,
    //金融部-交易管理-交易对配置
    'spotPair/save': spotPairCtrl.save,//新增
    'spotPair/update': spotPairCtrl.update,//修改
    'spotPair/list': spotPairCtrl.list,
    'spotPair/pushToCoreSystem': spotPairCtrl.pushToCoreSystem,
    'spotPair/getAllSubmitSuccess': spotPairCtrl.getAllSubmitSuccess,
    //运营部-其他管理-币种管理
    'coinType/save': coinTypeCtrl.save,
    'coinType/update': coinTypeCtrl.update,
    'coinType/list': coinTypeCtrl.list,
    'coinType/pushToCoreSystem': coinTypeCtrl.pushToCoreSystem,
    'coinType/getAllSubmitSuccess': coinTypeCtrl.getAllSubmitSuccess,

    //权限管理 - 我的权限
    'user/getInfo': userOptCtrl.getInfo,
    'user/getInfoByUserId': userOptCtrl.getInfoByUserId,
    'user/getInfoDetailByUserId': userOptCtrl.getInfoDetailByUserId,
    //权限管理 - 组织结构
    'department/pageList': departmentCtrl.pageList,
    'department/allList': departmentCtrl.allList,
    'department/getDepartmentTree': departmentCtrl.getDepartmentTree,
    'department/add': departmentCtrl.add,
    'department/update': departmentCtrl.update,
    'department/del': departmentCtrl.del,
    'department/userList/dpIdsOrAccount': departmentCtrl.getUserList,
    'position/allList': positionCtrl.allList,

    //权限管理 - 后台角色管理
    'acl/role/list': aclRoleAuthCtrl.roleList,
    'acl/role/getByUser': aclRoleAuthCtrl.getRoleByUser,
    'acl/role/getAll': aclRoleAuthCtrl.getAllRole,
    'acl/role/save': aclRoleAuthCtrl.saveRole,
    'acl/role/del': aclRoleAuthCtrl.delRole,
    //'acl/changeRoleAuth': aclRoleAuthCtrl.changeRoleAuth,
    'acl/auth/list': aclRoleAuthCtrl.authList,
    'acl/auth/tree': aclRoleAuthCtrl.getAuthTree,
    'acl/auth/getByUser': aclRoleAuthCtrl.getAuthByUser,
    'acl/auth/getByRole': aclRoleAuthCtrl.getAuthByRole,
    'acl/auth/save': aclRoleAuthCtrl.saveAuth,
    'acl/auth/del': aclRoleAuthCtrl.delAuth,

    //权限管理 - 后台用户管理
    'acl/user/add': aclUserCtrl.add,
    'acl/user/list': aclUserCtrl.list,
    'acl/user/update': aclUserCtrl.update,
    'acl/user/checkTotpCode': aclUserCtrl.checkTotpCode,
    'acl/changeUserRole': aclRoleAuthCtrl.changeUserRole,
    'acl/user/opt/log/list': aclUserCtrl.optLogList,

    'user/login': userOptCtrl.login,
    'user/logout': userOptCtrl.logout,
    'user/login/confirm': userOptCtrl.loginConfirm,
    'user/bind/totp/ask': userOptCtrl.bindTotpAsk,
    'user/bind/totp/confirm': userOptCtrl.bindTotpConfirm,
    'user/auth/reset/totp': userAuthConfigCtrl.resetTotp,

    //运营部-其他管理-热门交易对搜索
    'hot/pair/config/list': hotPairConfigCtrl.list,
    'hot/pair/config/add': hotPairConfigCtrl.add,
    'hot/pair/config/update': hotPairConfigCtrl.update,
    'hot/pair/config/del': hotPairConfigCtrl.del,

    //运营部-其他管理-消息通知
    'notice/list': noticeCtrl.list,
    'notice/add': noticeCtrl.add,
    'notice/update': noticeCtrl.update,


    //客服部-用户管理
    'mUser/manage/userList': mUserManageCtrl.userList,//Madex 用户管理 ->用户列表
    'mUser/manage/oneUserDetail': mUserManageCtrl.oneUserDetail,//Madex 用户管理 ->单个用户详情
    'mUser/manage/updateUserEmail': mUserManageCtrl.updateUserEmail,//Madex 用户管理 ->修改用户邮箱
    'mUser/manage/lockAccount': mUserManageCtrl.lockAccount,//Madex 用户管理 ->锁定账户
    'mUser/manage/unlockAccount': mUserManageCtrl.unlockAccount,//Madex 用户管理 ->解锁账户
    'mUser/manage/clearLoginLimit': mUserManageCtrl.clearLoginLimit,//Madex 用户管理 ->清除登陆限制
    'mUser/manage/clear24WithdrawLimit': mUserManageCtrl.clear24WithdrawLimit,//Madex 用户管理 ->清除24小时提现限制
    'mUser/manage/kyc/list': mUserRealNameCtrl.kycList,//Madex 用户管理 ->实名认证列表
    'mUser/manage/kyc/oneDetail': mUserRealNameCtrl.oneDetail,//Madex 用户管理 ->kyc详情
    'mUser/manage/kyc/audit': mUserRealNameCtrl.audit,//Madex 用户管理 ->kyc审核
    'mUser/manage/kyc/auditors': mUserRealNameCtrl.auditors,//Madex 用户管理 -> 所有审核人员
    'mUser/manage/walletAsset/detail': mUserAssetsCtrl.walletAssetDetail,//Madex 用户管理 ->钱包账户资产详情
    'mUser/manage/asset/distribution': mUserAssetsCtrl.assetDistribution,//Madex 用户管理 ->资产分布
    'mUser/manage/tradeAsset/detail': mUserAssetsCtrl.tradeAssetsDetail,//Madex 用户管理 ->交易账户资产详情
    'mUser/manage/order/pending/list': orderPendingAndHistoryCtrl.pendingList,//Madex 用户管理 ->当前委托
    'mUser/manage/order/history/list': orderPendingAndHistoryCtrl.historyList,//Madex 用户管理 ->历史委托
    'mUser/manage/order/detail/list': orderPendingAndHistoryCtrl.detailList,//Madex 用户管理 ->成交记录

    //运营部-现货-资源位管理
    'link/useful/list': usefulLinkCtrl.list,//链接记录列表
    'link/useful/add': usefulLinkCtrl.add,//添加链接记录
    'link/useful/delete': usefulLinkCtrl.del,//删除链接记录
    'link/useful/update': usefulLinkCtrl.update,//修改链接记录
    'link/useful/detail': usefulLinkCtrl.detail,//链接记录详情

    //运营部-其他管理-邮件订阅
    'mUser/subscribe/list': mUserSubscribeCtrl.list,//订阅列表
    'mUser/subscribe/delete': mUserSubscribeCtrl.del,//删除订阅
    'mUser/subscribe/count': mUserSubscribeCtrl.count,//订阅统计
    'mUser/subscribe/mail/history': mUserSubscribeCtrl.history,//发送历史
    'mUser/subscribe/mail/send': mUserSubscribeCtrl.mailSend,//邮件发送
    'mUser/subscribe/mail/detail': mUserSubscribeCtrl.mailDetail,//发送详情
    'mUser/subscribe/mail/send/group': mUserSubscribeCtrl.maiSendGroup,//群发邮件

    //运营部-现货-费率管理-普通用户手续费
    'mUser/fee/setting/list': commonUserFeeSettingCtrl.list,//普通用户手续费列表
    'mUser/fee/setting/add': commonUserFeeSettingCtrl.add,//新增普通用户手续费
    'mUser/fee/setting/update': commonUserFeeSettingCtrl.update,//修改普通用户手续费
    'mUser/fee/setting/delete': commonUserFeeSettingCtrl.del,//删除普通用户手续费
    'mUser/fee/setting/submit': commonUserFeeSettingCtrl.submit,//提交普通用户手续费
    'mUser/fee/vip/level/list': commonUserFeeSettingCtrl.vipLevelList,//用户等级费率列表

    //技术部-App管理-App版本管理
    'tech/app/version/list': appVersionCtrl.list,
    'tech/app/version/add': appVersionCtrl.add,
    'tech/app/version/update': appVersionCtrl.update,
    //技术部-App管理-App首页入口管理
    'tech/app/feature/list': appFeatureCtrl.list,
    'tech/app/feature/add': appFeatureCtrl.add,
    'tech/app/feature/update': appFeatureCtrl.update,
    'tech/app/feature/del': appFeatureCtrl.del,
    //技术部-App管理-App审核管理
    'tech/app/apply/version/list': appApplyVersionCtrl.list,
    'tech/app/apply/version/modify': appApplyVersionCtrl.modify,
    //技术部-App管理-App动态域名
    'tech/app/dynamic/domain/get': appDynamicDomainCtrl.get,
    'tech/app/dynamic/domain/update': appDynamicDomainCtrl.update,
    //技术部-App管理-App特定机型配置
    'tech/app/special/model/get': appSpecialModelCtrl.get,
    'tech/app/special/model/update': appSpecialModelCtrl.update,
    //技术部-其他管理-触发配置管理
    'tech/other/system/trigger/list': systemTriggerCtrl.list,
    'tech/other/system/trigger/add': systemTriggerCtrl.add,
    'tech/other/system/trigger/update': systemTriggerCtrl.update,
    'tech/other/system/trigger/del': systemTriggerCtrl.del,
    //技术部-其他管理-API限速管理
    'tech/other/apikey/strict/list': apikeyStrictCtrl.list,
    'tech/other/apikey/strict/add': apikeyStrictCtrl.add,
    'tech/other/apikey/strict/update': apikeyStrictCtrl.update,
    'tech/other/apikey/strict/del': apikeyStrictCtrl.del,
    //金融部-交易管理-合约代码配置
    'finance/trade/contract/pair/set': contractPairCtrl.set,
    'finance/trade/contract/pair/update': contractPairCtrl.update,
    'finance/trade/contract/pair/query': contractPairCtrl.query,
    //金融部-其他管理-现货做市参数配置
    'fiance/other/spot/market/maker/set': spotMarketMakerCtrl.set,
    'fiance/other/spot/market/maker/list': spotMarketMakerCtrl.list,
    'fiance/other/spot/market/maker/param/get': spotMarketMakerCtrl.paramGet,
    'fiance/other/spot/market/maker/param/set': spotMarketMakerCtrl.paramSet,
    //金融部-其他管理-合约做市参数配置
    'fiance/other/contract/market/maker/set': contractMarketMakerCtrl.set,
    'fiance/other/contract/market/maker/list': contractMarketMakerCtrl.list,
    'fiance/other/contract/market/maker/param/get': contractMarketMakerCtrl.paramGet,
    'fiance/other/contract/market/maker/param/set': contractMarketMakerCtrl.paramSet,
    //金融部-其他管理-合约限制交易配置
    'fiance/other/contract/limit/trade/set': contractLimitTradeCtrl.set,
    'fiance/other/contract/limit/trade/list': contractLimitTradeCtrl.list,
    //金融部-其他管理-合约接单账户配置(代理商)
    'fiance/other/contract/agent/set': contractAgentCtrl.agentSet,
    'fiance/other/contract/agent/list': contractAgentCtrl.agentList,
    //金融部-其他管理-合约接单账户关联(代理用户)
    'fiance/other/contract/agent/user/set': contractAgentCtrl.agentUserSet,
    'fiance/other/contract/agent/user/list': contractAgentCtrl.agentUserList,
    //金融部-其他管理-合约渠道用户管理(代理商渠道)
    'fiance/other/contract/agent/channel/set': contractAgentCtrl.agentChannelSet,
    'fiance/other/contract/agent/channel/list': contractAgentCtrl.agentChannelList,
    //客服部-资金管理-充值管理
    'custom/fund/deposit/record/list': depositAndWithdrawCtrl.depositList,
    //客服部-资金管理-提现管理
    'custom/fund/withdraw/record/list': depositAndWithdrawCtrl.withdrawList,

    //技术部-上币管理-上币申请
    'tech/apply/new/coin/list': coinTypeApplyCtrl.list,//申请上新币列表
    'tech/apply/new/coin/apply': coinTypeApplyCtrl.apply,//申请上新币
    'tech/apply/new/coin/apply/cancel/self': coinTypeApplyCtrl.cancelSelf,//撤销申请上新币
    'tech/apply/new/coin/apply/edit': coinTypeApplyCtrl.edit,//编辑申请上新币
    'tech/apply/new/coin/apply/review': coinTypeApplyCtrl.review,//审核申请上新币
    'tech/apply/new/coin/apply/rewrite': coinTypeApplyCtrl.rewrite,//驳回申请上新币
    'tech/apply/new/coin/apply/cancel': coinTypeApplyCtrl.cancel,//管理员取消申请上新币
    'tech/apply/new/coin/explore/url/list': coinTypeApplyCtrl.exploreUrlList,//交易浏览器列表
    'tech/apply/new/coin/listed': coinTypeApplyCtrl.listed,//已有币种列表
    //技术部-交易上下线管理-申请上新交易对
    'tech/apply/new/pair/list': pairApplyCtrl.list,//申请上交易对列表
    'tech/apply/new/pair/apply': pairApplyCtrl.apply,//申请上新交易对
    'tech/apply/new/pair/apply/cancel/self': pairApplyCtrl.cancelSelf,//撤销申请上新交易对
    'tech/apply/new/pair/apply/edit': pairApplyCtrl.edit,//编辑申请上新交易对
    'tech/apply/new/pair/apply/review': pairApplyCtrl.review,//审核申请上新交易对
    'tech/apply/new/pair/apply/rewrite': pairApplyCtrl.rewrite,//驳回申请上新交易对
    'tech/apply/new/pair/apply/cancel': pairApplyCtrl.cancel,//管理员取消申请上新交易对
    'tech/apply/new/pair/trade/area/list': pairApplyCtrl.tradeAreaList,//已有交易区列表
    'tech/apply/new/pair/listed': pairApplyCtrl.listed,//已有交易对列表
};

// TODO 这里先和 nodejs 的注册路由方式保持一样，后面在调整。

router.get('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!getFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.query, getFunc[path]);
});

router.post('/*', (req, res, next) => {
    let path = ReqUtils.parsePath(req.originalUrl);
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!postFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param, res).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.error(_func_name_, err);
        return Res3Utils.responseError(err, res);
    });
};

export const apiRouterV1 = router;
