import { ormDB, hotPairConfig } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";



let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');


export interface HotPairConfigVO {
    id?: number;

    pair?: string | any;

    weight?: number;
    type?: number;


    createdAt?: Date | any;

    updatedAt?: Date | any;


}

export interface HotPairConfigPageVO extends HotPairConfigVO {
    page?: number,

    size?: number
}

export async function list(pair: any,type:number, page: number, size: number) {
    let where = Object.create(null);
    if (pair) {
        where.pair = { [ormDB.Op.like]: `${pair}%` };
    }
    if (type==1) {
        where.type = 1;
    }else {
        where.type = 0;
    }

    let resList = await hotPairConfig.prototype.findAndCount({
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["weight", "desc"]],
        raw: true
    });
    return resList;
}

export async function add(hotPairConfigVO: HotPairConfigVO, currentUserId: any, ip: any) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            pair: hotPairConfigVO.pair
        },
        raw: true
    });

    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    hotPairConfigVO.createdAt = new Date();
    hotPairConfigVO.updatedAt = new Date();

    await hotPairConfig.prototype.create(hotPairConfigVO);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '新增热门搜索交易对配置', ip, JSON.stringify(hotPairConfigVO), '热门搜索交易对配置');
    return 'success'
}


export async function update(hotPairConfigVO: HotPairConfigVO, currentUserId: any, ip: any) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            pair: hotPairConfigVO.pair,
            id: { [ormDB.Op.ne]: hotPairConfigVO.id }
        },
        raw: true
    });

    if (dbInfo) {
        throw ErrorCode.DATA_EXIST;
    }
    hotPairConfigVO.updatedAt = new Date();

    await hotPairConfig.prototype.update({
        pair: hotPairConfigVO.pair,
        weight: hotPairConfigVO.weight
    }, {
        where: {
            id: Number(hotPairConfigVO.id)
        }
    });
    //管理后台操作日志
    addOptLog(currentUserId, 0, '修改热门搜索交易对配置', ip, JSON.stringify(hotPairConfigVO), '热门搜索交易对配置');
    return 'success'
}


export async function del(id: number, currentUserId: any, ip: any) {

    let dbInfo = await hotPairConfig.prototype.findOne({
        where: {
            id: id
        },
        raw: true
    });

    if (!dbInfo) {
        throw ErrorCode.DATA_NOT_EXIST;
    }

    await hotPairConfig.prototype.destroy({
        where: {
            id: Number(id)
        }
    });
    //管理后台操作日志
    addOptLog(currentUserId, 0, '删除热门搜索交易对配置', ip,`id:${id}`, '热门搜索交易对配置');
    return 'success'
}



