import * as assetCheckService from "../../service/v2/assetCheck.service";
import { CommonParam } from "../../service/v2/assetCheck.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../../constant/errorCode";

/**
 * 用户地址列表
 * @param req
 * @param commonParam
 */
export const userAddrList = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.userAddrList";
    try {
        setPageAndSize(commonParam);
        let res = await assetCheckService.userAddrList(commonParam.page, commonParam.size, commonParam.user_id);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 资产分布
 * @param req
 * @param commonParam
 */
export const assetDetails = async (req: any, commonParam: CommonParam) => {
    let func_name = "assetCheck.control.userAddrList";
    try {
        setPageAndSize(commonParam);
        if (!commonParam.user_id){
            throw ErrorCode.PARAM_MISS;
        }
       // let res = await assetCheckService.assetDetails(commonParam.page, commonParam.size, commonParam.user_id);
       // return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

function setPageAndSize(commonParam: CommonParam) {
    commonParam.page = commonParam.page ? Number(commonParam.page) : 1;
    commonParam.size = commonParam.size ? Number(commonParam.size) : 20;
}


