import { madAdminOrmDB, coinAddress, coinType } from "@madex/ex-ts-dao";
import { getOneAbkUserByAccount, getOneAbkUserByUid, checkAbkTotp } from "../../../../utils/abkUserUtils";
import { ErrorCode } from "../../../../constant/errorCode";
import { AbkUserInfoConst } from "../../../../constant/abkUserConstant";
import { CryptUtils } from "../../../../utils/crypt-utils";
import { RedisVal } from "../../../../constant/redis-val";
import Config from "../../../../../config";

const Otplib = require('otplib');

let { logger, apiAssertUtils: ApiAssert, BigNumberUtils } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');

let _ = require('lodash');

export interface CommonParam {
    user_id?: number;

    page?: number,

    size?: number
}


export async function userAddrList(page: any, size: any, user_id: any) {
    let where: any = {};
    if (user_id) {
        where["user_id"] = Number(user_id);
    }
    let res = await coinAddress.prototype.findAndCount({
        attributes: ['user_id', 'coin_id', 'coin_symbol', 'address', 'createdAt'],
        where: where,
        limit: size,
        offset: (page - 1) * size,
        order: [["createdAt", "desc"]],
        raw: true
    });
    if (res.rows.length) {
        let coinIds = res.rows.map(item => item.coin_id);
        let coinMap = await getCoinTypeMapByCoinIds(coinIds);
        for (let item of res.rows) {
            item.chain_type = coinMap[item.coin_id].chain_type;
            item.coin_symbol = coinMap[item.coin_id].symbol;
        }
    }
    return res;
}



async function getCoinTypeMapByCoinIds(coin_ids: any[]) {
    let map: any = {};
    let dbList = await coinType.prototype.findAll({
        where: {
            id: coin_ids
        },
        raw: true
    });
    for (let item of dbList) {
        map[item.id] = item;
    }
    return map;
}



