/**
 * 资产管理后台路由
 */
import Express from "express"

const {
    Res3Utils,
    logger,
} = require("@madex/ex-js-public");
const router = Express.Router();


import * as  abkUserCtrl from "../../mvc/control/v2/abkUserInfo.control";
import * as  assetCheckCtrl from "../../mvc/control/v2/assetCheck.control";
import Config from "../../../../config";


const postFunc = {
    //账号管理
    'abkUser/login': abkUserCtrl.login,
    'abkUser/logout': abkUserCtrl.logout,
    'abkUser/getInfo': abkUserCtrl.getInfo,
    'abkUser/getInfoDetailByUserId': abkUserCtrl.getInfoDetailByUserId,
    'abkUser/reset/totp': abkUserCtrl.resetTotp,
    'abkUser/get/totp': abkUserCtrl.getTotp,
    'abkUser/list': abkUserCtrl.userList,
    'abkUser/updateStatus': abkUserCtrl.updateStatus,
    'abkUser/addUser': abkUserCtrl.addAbkUser,
    //资产对账
    'assetCheck/userAddrList': assetCheckCtrl.userAddrList,
    'assetCheck/assetDetails': assetCheckCtrl.assetDetails,
    'assetCheck/depositAndWithDraw': assetCheckCtrl.assetDetails,
/*
    'user/login/confirm': userOptCtrl.loginConfirm,
    'user/bind/totp/ask': userOptCtrl.bindTotpAsk,
    'user/bind/totp/confirm': userOptCtrl.bindTotpConfirm,
    'user/auth/reset/totp': userAuthConfigCtrl.resetTotp,*/


};


router.post('/*', (req, res, next) => {
    //去除前缀
    let path = req.originalUrl.replace(Config.BASE_ABK_URL, "");
    if (!path) {
        return Res3Utils.responseError('4003', res);
    }

    if (!postFunc[path]) {
        return Res3Utils.responseError('4003', res);
    }

    doJob(req, res, next, req.body, postFunc[path]);

});

const doJob = (req, res, next, param, func) => {

    let _func_name_ = 'router.doJob';

    func(req, param, res).then(data => {
        res.json(data);
    }).catch(err => { // 可以抛出错误码
        logger.error(_func_name_, err);
        return Res3Utils.responseError(err, res);
    });
};

export const apiRouterV2 = router;
