import * as ReqUtils from "./req-utils";
import { ErrorCode } from "../constant/errorCode";
import { abkUserInfo, aclUserDepartmentPosition, madAdminOrmDB } from "@madex/ex-ts-dao";

let { logger } = require("@madex/ex-js-public");

let { apiAssertUtils: ApiAssert, BigNumberUtils } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');


/**
 * 通过 user_id 查询用户
 * @param user_id
 */
export const getOneAbkUserByUid = async function (user_id: number) {
    if (!user_id) {
        logger.error('abkUserUtils.getOneAbkUserByUid.error:' + 'user_id is null');
        throw ErrorCode.PARAM_MISS
    }
    let dbInfo = await abkUserInfo.prototype.findOne({
        where: {
            user_id: user_id,
        },
        raw: true
    });
    if (!dbInfo) {
        logger.error('abkUserUtils.getOneAbkUserByUid.error:' + 'dbInfo is null');
        throw ErrorCode.USER_NOT_EXIST
    }
    return dbInfo;
}
/**
 * 通过 account 查询用户
 * @param account
 */
export const getOneAbkUserByAccount = async function (account: string) {
    if (!account) {
        logger.error('abkUserUtils.getOneAbkUserByAccount.error:' + 'account is null');
        throw ErrorCode.PARAM_MISS
    }
    let dbInfo = await abkUserInfo.prototype.findOne({
        where: {
            account: account,
        },
        raw: true
    });
    if (!dbInfo) {
        logger.error('abkUserUtils.getOneAbkUserByAccount.error:' + 'dbInfo is null');
        throw ErrorCode.USER_NOT_EXIST
    }
    return dbInfo;
}

export const checkAbkTotp = async function (user_id: number, totp_code: string) {

    //获取谷歌密钥并验证
    let dbUserInfo = await getOneAbkUserByUid(user_id);
    ApiAssert.isTrue(ErrorCode.UNBOUND_TOTP, dbUserInfo && dbUserInfo.totp_encrypt !== '');
    await AuthCommon.totpCheckSync(totp_code, dbUserInfo.totp_encrypt)

    //判断是否已经使用过
    let latestVerifiedKey = "abk.totp.used.user." + user_id
    let latestUsed = RedisClient.getSync(latestVerifiedKey)
    ApiAssert.isFalse(ErrorCode.TOTP_CODE_USED, totp_code === latestUsed)
    await RedisClient.writeSync(latestVerifiedKey, totp_code, 60 * 60)
    return 'success';
}

export const isSuperUser = async function (user_id: any) {
    let dbUser = await getOneAbkUserByUid(user_id);
    if (!dbUser.user_type) {
        throw ErrorCode.NO_PERMISSION;
    }
}

