import * as service from "../service/coinType.service";
import { AddParam, ListParam } from "../service/coinType.service";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

let isIp = require('is-ip');

export const list = async (req: any, param: ListParam) => {
    let func_name = "coinTypeCtl.list";
    let cmd = req.path;
    try {
        param.page = Optional.opt(param, 'page', 1);
        param.size = Optional.opt(param, 'size', 50);
        let res = await service.list(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const chainList = async (req: any, param: ListParam) => {
    let func_name = "coinTypeCtl.chainList";
    let cmd = req.path;
    try {

        let res = await service.chainList();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const save = async (req: any, param: AddParam) => {
    let func_name = "coinTypeCtl.save";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.symbol);
        ApiAssert.notNull('3000', param.name);
        ApiAssert.notNull('3000', param.general_name);
        // ApiAssert.notNull('3000', param.is_active);
        ApiAssert.notNull('3000', param.is_main);
        ApiAssert.notNull('3000', param.original_decimals);
        ApiAssert.notNull('3000', param.valid_decimals);
        ApiAssert.notNull('3000', param.deposit_confirm_count);
        ApiAssert.notNull('3000', param.safe_confirm_count);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.save(param, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const update = async (req: any, param: AddParam) => {
    let func_name = "coinTypeCtl.update";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.id);
        ApiAssert.notNull('3000', param.symbol);
        ApiAssert.notNull('3000', param.name);
        ApiAssert.notNull('3000', param.general_name);
        ApiAssert.notNull('3000', param.is_active);
        ApiAssert.notNull('3000', param.is_main);
        ApiAssert.notNull('3000', param.original_decimals);
        ApiAssert.notNull('3000', param.valid_decimals);
        ApiAssert.notNull('3000', param.deposit_confirm_count);
        ApiAssert.notNull('3000', param.safe_confirm_count);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.update(param, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const pushToCoreSystem = async (req: any, param: AddParam) => {
    let func_name = "coinTypeCtl.pushToCoreSystem";
    let cmd = req.path;
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        ApiAssert.notNull('3000', param.id);
        let res = await service.pushToCoreSystem(param.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


export const getAllSubmitSuccess = async (req: any, param: ListParam) => {
    let func_name = "coinTypeCtl.getAllSubmitSuccess";
    let cmd = req.path;
    try {
        let res = await service.getAllSubmitSuccess();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const audit = async (req: any, param: AddParam) => {
    let func_name = "coinTypeCtl.audit";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.id);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.audit(param, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const mixinCoinList = async (req: any, param: ListParam) => {
    let func_name = "coinTypeCtl.list";
    let cmd = req.path;
    try {
        param.page = Optional.opt(param, 'page', 1);
        param.size = Optional.opt(param, 'size', 50);
        let res = await service.mixinCoinList(param);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const nftList = async (req: any, param: ListParam) => {
    let func_name = "coinTypeCtl.nftList";
    let cmd = req.path;
    try {

        let res = await service.nftList();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};
export const updateIconUrl = async (req: any, param: AddParam) => {
    let func_name = "coinTypeCtl.updateIconUrl";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.id);
        ApiAssert.notNull('3000', param.icon_url);
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await service.updateIconUrl(param, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
}

