import * as commonUserFeeSettingService from "../service/commonUserFeeSetting.service";
import { CommonUserFeeVO, CommonUserFeePageVO } from "../service/commonUserFeeSetting.service";

import { vipLevelFeeSetting } from "@madex/ex-ts-dao";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { IS_ACTIVE, IS_ACTIVE_ARR, LINK_TYPE_ARR } from "../../../constant/usefulLinkConst";
import { getCurrentUserId } from "../../../utils/aclUserUtils";
import { FEE_TYPE, FEE_TYPE_LIST } from "../../../constant/marketMakerConst";
import { baseCoinCheck, baseUCheck, spotCheck } from "../../../utils/feeRateCheckValidUtils";
import { getMUserInfoByUid } from "../../../utils/mUserUtils";
import { getFatherUserId } from "../service/mUserInfoSon.service";

let isIp = require('is-ip');
/**
 * 手续费列表
 * @param req
 * @param infoVO
 */
export const list = async (req: any, pageVO: CommonUserFeePageVO) => {
    let func_name = "commonUserFeeSetting.control.list";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await commonUserFeeSettingService.list(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 添加用户费率
 * @param req
 * @param authConfigVO
 */
export const add = async (req: any, commonUserFeeVO: CommonUserFeeVO) => {
    let func_name = "commonUserFeeSetting.control.add";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        await addParamValid(commonUserFeeVO);

        let res = await commonUserFeeSettingService.add(commonUserFeeVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 修改用户费率
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, commonUserFeeVO: CommonUserFeeVO) => {
    let func_name = "commonUserFeeSetting.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!commonUserFeeVO.id) {
            throw ErrorCode.PARAM_MISS;
        }
        await addParamValid(commonUserFeeVO);


        let res = await commonUserFeeSettingService.update(commonUserFeeVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 删除用户费率
 * @param req
 * @param authConfigVO
 */
export const del = async (req: any, commonUserFeeVO: CommonUserFeeVO) => {
    let func_name = "commonUserFeeSetting.control.del";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        if (!commonUserFeeVO.id) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await commonUserFeeSettingService.del(commonUserFeeVO.id, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


/**
 * 用户等级费率列表
 * @param req
 * @param infoVO
 */
export const vipLevelList = async (req: any, pageVO: CommonUserFeePageVO) => {
    let func_name = "commonUserFeeSetting.control.vipLevelList";
    try {
        let res = await commonUserFeeSettingService.vipLevelList();
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


async function addParamValid(commonUserFeeVO: CommonUserFeeVO) {
    let userId = commonUserFeeVO.user_id;
    let beginTime = commonUserFeeVO.begin_time;
    let expireTime = commonUserFeeVO.expire_time;
    let type = commonUserFeeVO.type;
    let levelId = commonUserFeeVO.level_id;
    let pair = commonUserFeeVO.pair;
    let applicant = commonUserFeeVO.applicant;
    let makerFee = commonUserFeeVO.maker_fee;
    let takerFee = commonUserFeeVO.taker_fee;

    if (!userId || !beginTime || !expireTime || !pair || !applicant || !makerFee || !takerFee) {
        throw ErrorCode.PARAM_MISS;
    }
    //撮合目前只支持 all 后续支持单个币对 可放开
    /*if (pair != 'all'){
        throw ErrorCode.PAIR_NOT_SUPPORT;
    }*/
    //校验费率范围
    if (type == FEE_TYPE.FEE_TYPE_SPOT) {
        if (Number(makerFee) < 0.0002 || Number(takerFee) < 0.0005) {
            throw ErrorCode.FEE_TOO_LOW_OR_HIGH;
        }
    }
    else {
        if (Number(makerFee) < -0.00015 || Number(takerFee) < 0.00035) {
            throw ErrorCode.FEE_TOO_LOW_OR_HIGH;
        }
    }
    await checkMaker(commonUserFeeVO);
    await paramCheck(beginTime, expireTime, Number(type), userId);

    if (levelId) {
        let vipLevelSetting = await vipLevelFeeSetting.prototype.findOne({
            where: {
                id: levelId
            },
            raw: true
        });
        if (!vipLevelSetting) {
            throw ErrorCode.LEVEL_NOT_EXIST;
        }
        if (type == FEE_TYPE.FEE_TYPE_SPOT) {
            commonUserFeeVO.maker_fee = vipLevelSetting.spot_maker;
            commonUserFeeVO.taker_fee = vipLevelSetting.spot_taker;
        }
        else {
            commonUserFeeVO.maker_fee = vipLevelSetting.contract_maker;
            commonUserFeeVO.taker_fee = vipLevelSetting.contract_taker;
        }
        return;
    }


    let user = await getMUserInfoByUid(userId);
    if (!user || user.deleted_flag == 1) {
        throw ErrorCode.USER_NOT_EXIST;
    }

    let fuid = await getFatherUserId(userId);
    if (fuid) {
        throw ErrorCode.SON_NOT_ADD_FEE;
    }

}


/**
 * 添加和更新校验入参
 * @param beginTime
 * @param expireTime
 * @param type
 * @param userId
 */
async function paramCheck(beginTime: any, expireTime: any, type: number, userId: number) {
//结束时间最少需要是一小时后；开始时间和结束时间最少需要间隔一小时
    if (datetimeUtils.between(expireTime, new Date()) < datetimeUtils.HOUR
        || datetimeUtils.between(expireTime, beginTime) < datetimeUtils.HOUR) {
        throw ErrorCode.PARAM_MISS;
    }
    if (isNaN(Number(type)) || !FEE_TYPE_LIST.includes(Number(type))) {
        throw ErrorCode.PARAM_MISS;
    }

    if (type == FEE_TYPE.FEE_TYPE_SPOT) {
        if (!await spotCheck(userId)) {
            throw ErrorCode.SPOT_NO_ASSETS;
        }
    }
    else if (type == FEE_TYPE.FEE_TYPE_CONTRACT) {
        if (!await baseUCheck(userId)) {
            throw ErrorCode.U_NO_ASSETS;
        }
    }
    else if (type == FEE_TYPE.FEE_TYPE_BASE_COIN_CONTRACT) {
        //TODO:暂不支持币本位的 因为不知道怎么区分交易对，之后需要再放开即可
        throw ErrorCode.PARAM_MISS;
        /*if (!await baseCoinCheck(userId)) {
            throw ErrorCode.COIN_NO_ASSETS;
        }*/
    }

}

async function checkMaker(commonUserFeeVO: CommonUserFeeVO) {
    let userChannel = commonUserFeeVO.user_channel;
    if (!userChannel) {
        throw ErrorCode.PARAM_MISS
    }
    //项目方
    if (userChannel == 2) {
        //项目方只允许现货并且单个交易对
        if (Number(commonUserFeeVO.type) != 1 || commonUserFeeVO.pair == 'all') {
            throw ErrorCode.PARAM_MISS;
        }
        let statisPeriod = commonUserFeeVO.statis_period;
        let amount_require_usdt = commonUserFeeVO.amount_require_usdt;
        if (!statisPeriod || Number(statisPeriod) < 0 || Number(statisPeriod) > 30) {
            throw ErrorCode.PARAM_MISS;
        }
        if (!amount_require_usdt) {
            throw ErrorCode.PARAM_MISS;
        }
    }
}