import * as airdropService from "../service/airdrop.service";
import { AirdropVO, AirdropPageVO } from "../service/airdrop.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');


export const list = async (req: any, airdropPageVO: AirdropPageVO) => {
    let func_name = "airdropCtrl.list";
    try {
        airdropPageVO.page = Optional.opt(airdropPageVO, 'page', 1);
        airdropPageVO.size = Optional.opt(airdropPageVO, 'size', 20);
        let res = await airdropService.list(airdropPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

export const prizeList = async (req: any, airdropPageVO: AirdropPageVO) => {
    let func_name = "airdropCtrl.prizeList";
    try {
        airdropPageVO.page = Optional.opt(airdropPageVO, 'page', 1);
        airdropPageVO.size = Optional.opt(airdropPageVO, 'size', 20);
        let res = await airdropService.prizeList(airdropPageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


export const save = async (req: any, airdropVO: AirdropVO) => {
    let func_name = "airdropCtrl.save";
    try {


        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.name);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.symbol);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.total);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.hard_limit);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.lock_type);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.lock_symbol);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.lock_name);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.lock_time);
        // weight [["1-100","3"],["101-1000","7"]]
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.weight);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.start_time);
        ApiAssert.notNull(ErrorCode.PARAM_MISS, airdropVO.end_time);

        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);
        let res = await airdropService.save(airdropVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

