import * as mUserBillsService from "../service/mUserBills.service";
import { QueryVO } from "../service/mUserBills.service";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";

/**
 * 账单类型列表
 * @param req
 * @param infoVO
 */
export const billTypeList = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserBillsCtrl.billTypeList";
    try {
        if (!queryVO.account_type) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await mUserBillsService.billTypeList(queryVO.account_type);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 账单详情
 * @param req
 * @param infoVO
 */
export const billDetailList = async (req: any, queryVO: QueryVO) => {
    let func_name = "mUserAssetsCtrl.billDetailList";
    try {
        queryVO.page = Optional.opt(queryVO, 'page', 1);
        queryVO.size = Optional.opt(queryVO, 'size', 20);
        if (!queryVO.account_type) {
            throw ErrorCode.PARAM_MISS
        }
        if (!queryVO.user_id) {
            throw ErrorCode.PARAM_MISS
        }
        if (!queryVO.from_time) {
            throw ErrorCode.PARAM_MISS
        }
        if (!queryVO.to_time) {
            throw ErrorCode.PARAM_MISS
        }
        let res = await mUserBillsService.billDetailList(queryVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};


