let { ossUtils } = require('@madex/ex-js-common');
let { logger } = require('@madex/ex-js-public');
const sizeOf = require('image-size');
const axios = require("axios");

/**
 *
 * @param url
 * @param text
 * @param font_size
 */
export const resizeWithWaterMark = async function (url: string, text: string, font_size?: number) {
    let waterUrl = await getWatermarkUrl(url, text, font_size ? font_size : 60)
    return waterUrl;
}


let getImageWidth = async function (urlStr: string) {
    try {
        let response = await axios({
            url: urlStr,
            method: 'GET',
            responseType: 'arraybuffer'
        });
        let dimensions = sizeOf(response.data);
        let width = dimensions ? dimensions.width : 0;
        return width;
    }
    catch (e) {
        logger.error("OSSUtils.getImageWidth.error:" + e);
        return 0;
    }
}

export const withWaterMark = async function (url: string, text: string) {
    let imgUrl = await ossUtils.getUrl(url);
    let imageWidth = await getImageWidth(imgUrl);
    if (imageWidth <= 0) {
        imageWidth = 1000;
    }
    let fontSize = Math.round((imageWidth / 5));
    if (fontSize > 999) {
        fontSize = 999;
    }
    let waterUrl = await getWatermarkUrl(url, text, fontSize);
    return waterUrl;
}

/**
 * 获取带水印的图片地址
 * @param url url
 * @param text 水印文案
 * @param size 水印大小
 */
let getWatermarkUrl = async function (url: string, text: string, size?: number) {
    let base64 = Buffer.from(text).toString('base64');
    let textWatermark = base64.replace("+", "-").replace('/', '_').replace("=", "");
    return ossUtils.getUrlWatermark(url, textWatermark, size);
}


