import { coinType } from "@madex/ex-ts-dao";

const axios = require("axios");
const _ = require("lodash");

import configSetting from "./../../config"

const webadmin_endpoint = configSetting.webadmin_endpoint
let { logger } = require('@madex/ex-js-public');

// { id: 1, symbol: 'BTC' }
export const getCoinFromCore = async (symbol) => {
    const url = `${webadmin_endpoint}/asset/by_symbol?symbol=${symbol}`
    let { data } = await axios.get(url);
    if (data.state != 0) {
        logger.error("getCoinFromCore", data.msg);
        return null
    }
    return data.result[0];
}

// {"market":"spot",
// "symbol":"BTC_USDT",
// "takerFee":"0.001",
// "minOrderSize":"0",
// "quantityIncrement":"0.01",
// "makerFee":"0.001",
// "priceIncrement":1,"
// quantityScale":2,
// "priceScale":4,
// "maxOrderSize":"0",
// "maxOrderValue":"0",
// "minOrderValue":"0"}
// 合约的话还有多余对应db字段 predictedFundingRate nextFundingTime ...
export const getPairFromCore = async (symbol) => {
    const url = `${webadmin_endpoint}/pair/by_symbol?symbol=${symbol}`
    let { data } = await axios.get(url);
    if (data.state != 0) {
        logger.error("getPairFromCore", data.msg);
        return null
    }
    return data.result[0]
}

// res：
// [{"name":"BTC","asset":1,"balance":"10","holds":"0"}]
export const getUserAccountFromCore = async (userId, withName = true) => {
    const url = `${webadmin_endpoint}/account/list?user_id=${userId}`
    let { data } = await axios.get(url);

    if (data.state != 0) {
        logger.error("getUserAccountFromCore", data.msg);
        return null
    }
    let assets = data.result

    let asset_id = _.map(assets, 'asset');
    if (withName) {
        let names = await coinType.prototype.findAll({
            attributes: ['general_name', 'asset_id'],
            where: {
                asset_id,
                is_main: 1
            },
            raw: true
        })
        let m = _.keyBy(names, 'asset_id');
        for (const item of assets) {
            if (m[item.asset]) {
                item.name = m[item.asset].general_name
            }
        }
    }

    return assets;
}

// user_id
// status, // 必须 unsettled或者settled
// symbol, // 可选，交易对
// start_time, // 成交时间
// end_time, // 成交时间
// before, // update_id
// after, // update_id
// limit, / 数量
// res:
// [{"orderId":"4611689316962271233","clientOrderId":"","createTime":"1725261917795","product":"BTC_USDT","type":1,"side":"buy","quantity":"1","stf":"disabled","price":"9999.0000","visibleQty":"1","timeInForce":"gtc","cancelAfter":0,"postOnly":false,"status":"accepted","executedQty":"0","fillCount":0,"fills":[],"fees":[],"updateTime":"1725261917795"},{"orderId":"4611689316962271234","clientOrderId":"","createTime":"1725261919337","product":"BTC_USDT","type":1,"side":"buy","quantity":"1","stf":"disabled","price":"9998.0000","visibleQty":"1","timeInForce":"gtc","cancelAfter":0,"postOnly":false,"status":"accepted","executedQty":"0","fillCount":0,"fills":[],"fees":[],"updateTime":"1725261919337"}]
export const getUserOrdersFromCore = async (params) => {
    // let params = new URLSearchParams();
    const url = `${webadmin_endpoint}/order/list`
    let { data } = await axios.get(url, { params });
    if (data.state != 0) {
        logger.error("getUserOrdersFromCore", data.msg);
        return null
    }
    return data.result
}

// user_id
// symbol, // 可选，交易对
// start_time, // 成交时间
// end_time, // 成交时间
// before, // update_id
// after, // update_id
// limit, / 数量
// order_id 可选
export const getUserFillsFromCore = async (params) => {
    // let params = new URLSearchParams();
    const url = `${webadmin_endpoint}/fill/list`
    let { data } = await axios.get(url, { params });
    if (data.state != 0) {
        logger.error("getUserFillsFromCore", data.msg);
        return null
    }
    return data.result
}


// getUserOrdersFromCore({user_id:1})

export const addCoin2Core = async (symbol, id) => {
    let res = {
        is_success: true,
        err_msg: ""
    }
    const url = `${webadmin_endpoint}/asset/add`
    let body = {
        "symbol": symbol,
        "id": id,
    }
    let { data } = await axios.post(url, body);
    if (data.state != 0) {
        logger.error("addCoin2Core", data.msg);
        res.is_success = false;
        res.err_msg = data.msg;
    }
    return res;
}

export const addPairToCore = async (body) => {
    let res = {
        is_success: true,
        err_msg: ""
    }
    const url = `${webadmin_endpoint}/pair/add_product`
    let { data } = await axios.post(url, body);
    if (data.state != 0) {
        logger.error("addPairToCore", data.msg);
        res.is_success = false;
        res.err_msg = data.msg;
    }
    return res;
}

// 设置手续费 至少指定user_id 和 symbol 二者其一
export const changeTradingFee = async (symbol,user_id,maker_fee,taker_fee) => {
    let body = {
        maker_fee,taker_fee,
    }
    if (symbol) {
        body["symbol"] = symbol;
    }
    if (user_id>0) {
        body["user_id"] = user_id;
    }
    let res = {
        is_success: true,
        err_msg: ""
    };
    const url = `${webadmin_endpoint}/market_maker/change_trading_fee`
    let { data } = await axios.post(url, body);
    if (data.state != 0) {
        logger.error("addPairToCore", data.msg);
        res.is_success = false;
        res.err_msg = data.msg;
    }
    return res;
}
