/**
 * redis中常用值
 */

 const RedisValInner = Object.freeze({
    LOGIN_ERROR_TIMES_SUFFIX: ".PARTNER_LOGIN_ERROR_COUNT",
    SESSION_ID_LIST_SUFFIX: ".PARTNER_SESSION_ID_LIST",
})

export const RedisVal = {
    loginErrTimesKey: (userId: any) => `${userId}${RedisValInner.LOGIN_ERROR_TIMES_SUFFIX}`,
    sessionListKey: (userId: any) => `${userId}${RedisValInner.SESSION_ID_LIST_SUFFIX}`,
}

/**
 * App审核管理
 */
export const APP_VERSION_KEY = "app:apply:version:"; // 防止之后会有android

/**
 * app动态域名配置在缓存中的KEY前缀。
 */
export const  ADDRESS_INFO_REDIS_KEY = "b029.addressInfo.service.get";

/**
 * app动态域名对象配置在缓存中的KEY前缀。
 */
export const  ADDRESS_INFO_REDIS_KEY_OBJ = "b029.addressInfo.service.get.obj";

/**
 * App特定机型配置
 */
export const APP_SPECIAL_MODEL_REDIS_KEY = "b029.app.sepecial.model.redis.key";


/**
 * 返佣时间周期配置
 */
export const REWARD_TIME_PERIOD_REDIS_KEY = "bk_reward_time_period_config";

/**
 * Madex 用户的SessionId集合
 */
export const M_SESSION_ID_PREFIX = "session_id.list."


