import { userAgent, } from "@madex/ex-ts-dao";
import { ErrorCode } from "../../../constant/errorCode";
import { addOptLog } from "./userOptLog.service";
import { addAgentSetting, getAgentSettings, setAgent } from "../../../utils/coreSystemUtils";


let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');

let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, } = require('@madex/ex-js-common');


export interface AgentVO {
    id?: number,

    user_id?: number;

    adl_type?: number;

    enable?: number;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}

export interface AgentUserVO {
    id?: number,

    user_id?: number;

    agent_id?: number;

    ratio?: number;

    product?: string;

    createdAt?: Date | any,

    updatedAt?: Date | any,

}


export interface AgentPageVO extends AgentVO, AgentUserVO {

    page?: number,

    size?: number,

}


export async function hedgeRatioList(agent_id: any) {
    return await getAgentSettings(agent_id);
}

export async function agentList(pageVO: AgentPageVO) {
    let where = {};
    if (pageVO.user_id) {
        where["user_id"] = pageVO.user_id;
    }
    if (pageVO.agent_id) {
        where["agent_id"] = pageVO.agent_id;
    }
    let page = Number(pageVO.page);
    let size = Number(pageVO.size);
    let res = await userAgent.prototype.findAndCount({
        where:where,
        offset:page*size - size,
        limit:size,
        raw:true
    });

    return res;
}

export async function agentSet(user_id: any, currentUserId: any, ip: string | undefined) {
    let exist = await userAgent.prototype.find({
        where: {
            user_id
        },
        raw: true
    });
    if (exist && exist.agent_id != 0) {
        throw ErrorCode.DATA_EXIST;
    }else {
        await setAgent(user_id, user_id);
    }

    addOptLog(currentUserId, 0, '合约接单账户配置', ip, user_id, '合约接单账户配置');
    return 'success';
}

export async function hedgeRatioSet(agentUserVO: AgentUserVO, currentUserId: any, ip: string | undefined) {

    let agent_id = agentUserVO.agent_id;
    let symbol = agentUserVO.product;
    let ratio = agentUserVO.ratio;

    let market = "lpc" // 固定 只有合约才对冲设置

    let exist = await userAgent.prototype.find({
        where: {
            user_id:agent_id,
            agent_id
        },
        raw: true
    });
    if (!exist) {
        throw ErrorCode.DATA_NOT_EXIST;
    }
    await addAgentSetting(agent_id, market, symbol, ratio);

    addOptLog(currentUserId, 0, '合约接单账户配置对冲', ip, JSON.stringify(agentUserVO), '合约接单账户配置对冲');
    return 'success';
}


export async function agentUserList(pageVO: AgentPageVO) {
    let where = {};
    if (pageVO.user_id) {
        where["user_id"] = pageVO.user_id;
    }
    if (pageVO.agent_id) {
        where["agent_id"] = pageVO.agent_id;
    }
    let page = Number(pageVO.page);
    let size = Number(pageVO.size);
    let res = await userAgent.prototype.findAndCount({
        where:where,
        offset:page*size - size,
        limit:size,
        raw:true
    });

    return res;
}


export async function agentUserSet(agentUserVO: AgentUserVO, currentUserId: any, ip: string | undefined) {

    let user_id = agentUserVO.user_id;
    let agent_id = agentUserVO.agent_id;
    let exist = await userAgent.prototype.find({
        where: {
            user_id,
            agent_id
        },
        raw: true
    });
    if (exist && exist.agent_id != 0) {
        throw ErrorCode.DATA_EXIST;
    }else {
        await setAgent(user_id, agent_id);
    }
    //管理后台操作日志
    addOptLog(currentUserId, 0, '合约接单账户关联配置', ip, JSON.stringify(agentUserVO), '合约接单账户关联');
    return 'success';
}

export async function agentChannelList(pageVO: AgentPageVO) {
    let key = 'contractAgent.service.agentChannelList';
    //TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    let list = await RedisClient.getSync(key);
    let res = {
        count: list ? list.length : 0,
        rows: list ? list : []
    }
    return res;
}


export async function agentChannelSet(agentUserVO: AgentUserVO, currentUserId: any, ip: string | undefined) {
//TODO:目前在缓存里 方便调试 后期撮合搞定之后再修改
    agentUserVO.createdAt = new Date();
    agentUserVO.updatedAt = new Date();
    let key = 'contractAgent.service.agentChannelList';
    let list = await RedisClient.getSync(key);
    if (list) {
        agentUserVO.id = list.length + 1;
        list.push(agentUserVO);
    }
    else {
        agentUserVO.id = 1;
        list = [];
        list.push(agentUserVO);
    }
    await RedisClient.writeSync(key, list);
    //管理后台操作日志
    addOptLog(currentUserId, 0, '合约渠道用户配置', ip, JSON.stringify(agentUserVO), '合约渠道用户管理');
    return 'success';
}


