let express = require('express');
let errorHandler = require('errorhandler');
let logger = require("@madex/ex-js-public").logger;


/* ======================================================================
 * Config
 * ====================================================================== */
let app = express();


logger.use(app);
// express 全局设定
require('@madex/ex-js-common').expressSetting(app);
// Request frequency limit
const limitList = [

];
require("@madex/ex-js-common").frequencyLimiting.cookieLimitForCmd(app, limitList);

require("@madex/ex-js-common").apiExceedAlertUtils.check(app, { projectNO: 20, expireTime: 1000 }) // 检查
import configSetting from "./config"

if (configSetting.node_env == "development") {
    app.use(errorHandler());
}
else {
    app.use(function (err, req, resp, next) {
        logger.warn('500 error ', err);
        return resp.status(500).send();
    });
}

/* ======================================================================
 * internal Router
 * ====================================================================== */
// require('./setting/access-limit')(app);
// require('./setting/apikey-filter')(app);
// require('./setting/need-login')(app);
// require('./setting/need-newotc')(app);

// if (configSetting.node_env === 'development') {
//     require("./setting/swagger-setting")(app);
//     app.listen(3020, () => logger.info("South Gate to Heaven swagger started!! suffix : 3020/southHeaven"));
// }

import { apiRouterV1 } from "./src/functional/router/v1/index"

app.use('/admin/v1', apiRouterV1);


//启动Server
// app.listen(configSetting.port, function () {
//     // logger.info("Wallet Gateway-(bibox_b020_southgatetoheaven) server listening on %d, in %s mode", configSetting.port, app.get("env"));
//     // wxUtils.serviceStartSend('bibox_b020_southgatetoheaven');
// });

// 输出进程错误
process.on('uncaughtException', (error) => {
    let error_msg = JSON.stringify(error)
    logger.error("uncaughtException:", error_msg)
})

// 输出未捕获异常
process.on('unhandledRejection', (error, promise) => {
    promise.catch(err => {
        logger.warn("unhandledRejection:", JSON.stringify(err.message))
    })
});

// console.log(configSetting)
app.listen(configSetting.port, '0.0.0.0', () => {
    logger.info(
        'demo',
        configSetting.port,
        app.get('env'),
    );
});
