import * as service from "../service/spotPair.service";
import { AddParam, ListParam } from "../service/spotPair.service";

let { logger, ResponseUtils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');


export const list = async (req: any, param: ListParam) => {
    let func_name = "spotPairCtl.list";
    let cmd = req.path;
    try {
        param.page = Optional.opt(param, 'page', 1);
        param.size = Optional.opt(param, 'size', 50);
        let res = await service.list(param);
        return ResponseUtils.success(cmd, res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return ResponseUtils.error(func_name, cmd, e);
    }
};

export const add = async (req: any, param: AddParam) => {
    let func_name = "spotPairCtl.add";
    let cmd = req.path;
    try {
        ApiAssert.notNull('3000', param.base);
        ApiAssert.notNull('3000', param.quote);
        ApiAssert.notNull('3000', param.symbol);
        ApiAssert.notNull('3000', param.name);
        ApiAssert.notNull('3000', param.price_scale);
        ApiAssert.notNull('3000', param.quantity_scale);
        ApiAssert.notNull('3000', param.maker_fee);
        ApiAssert.notNull('3000', param.taker_fee);
        let res = await service.add(param);
        return ResponseUtils.success(cmd, res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return ResponseUtils.error(func_name, cmd, e);
    }
};
