// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { coinType, ormDB } from "@madex/ex-ts-dao";


export interface ListParam {
    symbol: string | any;

    page: number;

    size: number;
}

export interface AddParam {
    symbol: string;

    is_active: number;

    is_main: number;

    name: string;

    general_name: string;

    chain_type?: string;

    original_decimals: number;

    valid_decimals: number;

    contract?: string;

    contract_father?: string;

    enable_deposit?: number;

    enable_withdraw?: number;

    enable_transfer?: number;

    withdraw_fee?: number;

    withdraw_min?: number;

    deposit_min?: number;

    deposit_confirm_count: number;

    safe_confirm_count: number;

    explor_url?: string;

    icon_url?: string;

    describe_url?: string;

    forbid_info?: string;

    describe_summary?: string;

    total_amount?: number;


    supply_amount?: number ;

    circulation_rate?: number ;

    address_num?: number;

    price?: string ;

    supply_time?:string ;

    deflation_rate?:number ;

    comment?: string ;

    max_transfer_amount?: number ;

    tag: string;

    forbid_info_related?: number ;

    is_hidden?: number ;

    main_status?: number ;
}


export async function list(param: ListParam) {
    let where = {};
    if (param.symbol) {
        where["symbol"] = { [ormDB.Op.like]: `%${param.symbol}%` };
    }
    let resList = await coinType.prototype.findAndCount({
        where: where,
        limit: param.size,
        offset: (param.page - 1) * param.size,
        order: [["id", "desc"]],
        raw: true
    });
    return resList;
}

export const add = async (param: AddParam) => {
    await coinType.prototype.create(param);
    return 'ok';
};

