// @madex/ex-ts-dao 是 ts 的 dao, 代码在 bitbucket/ex-js-dao 的 ts 分支上
import { ErrorCode } from "../../../constant/errorCode";
import { getOneAclUserByAccount, getOneAclUserByUid } from "../../../utils/aclUserUtils";
import { RedisVal } from "../../../constant/redis-val";


let { apiAssertUtils: ApiAssert, datetimeUtils: DatetimeUtils } = require('@madex/ex-js-public');
let { authCommon: AuthCommon, redisUtilsCommon: RedisClient, BigNumberUtils } = require('@madex/ex-js-common');

let _ = require('lodash');
let { logger } = require('@madex/ex-js-public');

const Otplib = require('otplib');


export interface AuthConfigVO {
    id?: number;

    user_id?: number;

    totp_encrypt?: string | any;

    is_locked?: number | any;

    locked_time?: Date | any;

    force?: number | any;

    deadline?: Date | any;

    createdAt?: Date | any;

    updatedAt?: Date | any;

    totp_code?: any

}

export interface AuthConfigPageVO extends AuthConfigVO {
    page?: number,

    size?: number
}


export async function resetTotp(userId: number | undefined) {
    if (userId) {
        let userInfo = await getOneAclUserByUid(Number(userId));
        ApiAssert.isNotEmpty(ErrorCode.USER_NOT_EXIST, userInfo);
    }
    //生成新的密钥
    let totpEncrypt = Otplib.authenticator.generateSecret();
    let email = userId ? userId : 0 + '-' + totpEncrypt.slice(0, 3)
    let uri = 'otpauth://totp/' + email + '?secret=' + totpEncrypt + '&issuer=team888';
    return { uri: uri, totpEncrypt: totpEncrypt };
}


export async function _deleteAllSessionByUserId(userId: number) {

    //获取该账户使用过的所有sessionId
    let sessionListKey = RedisVal.sessionListKey(userId)
    RedisClient.lrange(sessionListKey, 0, -1, async (err, reply) => {
        //删除所有sessionId
        if (!err && reply && reply.length >= 1) {
            await RedisClient.delSync(...reply)
        }
        //删除sessionList
        await RedisClient.delSync(sessionListKey)
    })
}



