'use strict';
import * as ReqUtils from "../utils/req-utils";

const {
    Res3Utils,
    logger: Logger,
} = require("@madex/ex-js-public");



let cmdWhiteList = {'i18n/info/list': 1,
    'i18n/info/add': 1,
    'i18n/info/update': 1,
    'i18n/info/del': 1,
    'i18n/info/log/list': 1,
    'i18n/info/log/revert': 1,
    'spotpair/add': 1,
    'spotpair/list': 1,
    'coinType/add': 1,
    'coinType/list': 1,
    'acl/user/add': 1,
    'acl/user/list': 1,
    'acl/user/update': 1,
    'acl/user/updateStatus': 1,
    'acl/user/resetPwd': 1,
    'acl/auth/list': 1,
    'acl/auth/tree': 1,
    'acl/auth/getByUser': 1,
    'acl/auth/getByRole': 1,
    'acl/auth/save': 1,
    'acl/auth/del': 1,
    'acl/role/list': 1,
    'acl/role/getByUser': 1,
    'acl/role/getAll': 1,
    'acl/role/save': 1,
    'acl/role/del': 1,
    'acl/changeRoleAuth': 1,
    'acl/changeUserRole': 1,
    'user/getInfo': 1,
    'user/login': 1,
    'user/logout': 1,
    'user/login/confirm': 1,
    'user/updatePwd': 1,
    'user/bind/totp/ask': 1,
    'user/bind/totp/confirm': 1,
    'user/auth/config/list': 1,
    'user/auth/change/force/status': 1,
    'user/auth/change/locked/status': 1,
    'user/auth/reset/totp': 1,
    'hot/pair/config/list': 1,
    'hot/pair/config/add': 1,
    'hot/pair/config/update': 1,
    'hot/pair/config/del': 1,
    'notice/list': 1,
    'notice/add': 1,
    'notice/update': 1,
};


let filter = function (app: any) {
    app.use(function (req, res, next) {
        let path = ReqUtils.parsePath(req.originalUrl);
        try {
            //如果是非登录接口，可以直接跳过
            if (!cmdWhiteList[path]) {
                throw '3000'
            }
            next();
        }
        catch (e) {
            Logger.error(`access-limit filter error!! - ${e}`);
            return res.json(Res3Utils.getErrorResult(e));
        }
    });
};
module.exports = {
    filter: filter,
};