import * as contractPairService from "../service/contractPair.service";
import { ContractPairPageVO, ContractPairVO } from "../service/contractPair.service";


let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert, datetimeUtils } = require('@madex/ex-js-public');
import { ErrorCode } from "../../../constant/errorCode";
import { getCurrentUserId } from "../../../utils/aclUserUtils";

let isIp = require('is-ip');
/**
 * 金融部-交易管理-合约查询交易对
 * @param req
 * @param infoVO
 */
export const query = async (req: any, pageVO: ContractPairPageVO) => {
    let func_name = "contractPair.control.query";
    try {
        pageVO.page = Optional.opt(pageVO, 'page', 1);
        pageVO.size = Optional.opt(pageVO, 'size', 20);
        let res = await contractPairService.query(pageVO);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-交易管理-合约设置交易对
 * @param req
 * @param authConfigVO
 */
export const set = async (req: any, contractPairVO: ContractPairVO) => {
    let func_name = "contractPair.control.set";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);

        let res = await contractPairService.set(contractPairVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

/**
 * 金融部-交易管理-合约更新交易对
 * @param req
 * @param authConfigVO
 */
export const update = async (req: any, contractPairVO: ContractPairVO) => {
    let func_name = "contractPair.control.update";
    try {
        let ip = isIp(req.ip) ? req.ip : '*.*.*.*';
        let currentUserId = await getCurrentUserId(req.cookies.session_id);

        let res = await contractPairService.update(contractPairVO, currentUserId, ip);
        return Res3Utils.result(res);
    }
    catch (e) {
        logger.error(`${func_name} error:${e}`);
        return Res3Utils.getErrorResult(e);
    }
};

