import * as aclPositionService from "../service/aclPosition.service";
import { AclAuthVO, AclAuthPageVO, AclRolePageVO, AclRoleVO } from "../service/aclRoleAuth.service";
import { getCurrentUserId, } from "../../../utils/aclUserUtils";
import { ErrorCode } from "../../../constant/errorCode";
import { getUserFillsFromCore, getUserOrdersFromCore } from "../../../utils/coreSystemUtils";

let { logger, Res3Utils, optionalUtils: Optional, apiAssertUtils: ApiAssert } = require('@madex/ex-js-public');

export interface QueryVo {
    user_id?: number

    before?: string

    after?: string

    limit?: number
}

export const pendingList = async (queryVo: QueryVo) => {
    let param = {
        user_id: queryVo.user_id,
        status: "unsettled"//当前委托
    }
    let res = await getUserOrdersFromCore(param);
    return res;
};

export const historyList = async (queryVo: QueryVo) => {
    let param = {
        user_id: queryVo.user_id,
        status: "settled"//历史委托
    }
    if (queryVo.before) {
        param['before'] = queryVo.before
    }
    if (queryVo.after) {
        param['after'] = queryVo.after
    }
    if (queryVo.limit) {
        param['limit'] = queryVo.limit
    }
    let res = await getUserOrdersFromCore(param);
    return res;
};

export const detailList = async (queryVo: QueryVo) => {
    let param = {
        user_id: queryVo.user_id,
    }
    if (queryVo.before) {
        param['before'] = queryVo.before
    }
    if (queryVo.after) {
        param['after'] = queryVo.after
    }
    if (queryVo.limit) {
        param['limit'] = queryVo.limit
    }
    let res = await getUserFillsFromCore(param);
    return res;
};



